-- Smart School Database Backup
-- Generated: 2025-04-07 12:00:42
-- --------------------------------------------------------

-- Table structure for table `academic_bkash_refunds`
DROP TABLE IF EXISTS `academic_bkash_refunds`;
CREATE TABLE `academic_bkash_refunds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(200) NOT NULL,
  `course_id` varchar(500) NOT NULL,
  `payment_id` varchar(200) NOT NULL,
  `original_trx_id` varchar(200) NOT NULL,
  `refund_trx_id` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `reason` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `academic_bkash_refunds`


-- Table structure for table `academic_onpay_seetings`
DROP TABLE IF EXISTS `academic_onpay_seetings`;
CREATE TABLE `academic_onpay_seetings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `SSL_domain_name` varchar(300) NOT NULL,
  `SSL_IS_SANDBOX` varchar(300) NOT NULL,
  `SSL_STORE_ID` varchar(300) NOT NULL,
  `SSL_STORE_PASSWORD` varchar(300) NOT NULL,
  `bkash_base_url` varchar(300) NOT NULL,
  `bkash_username` varchar(300) NOT NULL,
  `bkash_password` varchar(300) NOT NULL,
  `bkash_app_key` varchar(300) NOT NULL,
  `bkash_app_secret` varchar(300) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `academic_onpay_seetings`


-- Table structure for table `academic_year`
DROP TABLE IF EXISTS `academic_year`;
CREATE TABLE `academic_year` (
  `academic_year_id` int(11) NOT NULL AUTO_INCREMENT,
  `academic_year_name_bn` varchar(255) DEFAULT NULL,
  `academic_year_name_en` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`academic_year_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `academic_year`
INSERT INTO `academic_year` (`academic_year_id`, `academic_year_name_bn`, `academic_year_name_en`) VALUES("4","2024-2025","2024-2025");
INSERT INTO `academic_year` (`academic_year_id`, `academic_year_name_bn`, `academic_year_name_en`) VALUES("5","2025-2026","2025-2026");


-- Table structure for table `accounting_bkash_pay`
DROP TABLE IF EXISTS `accounting_bkash_pay`;
CREATE TABLE `accounting_bkash_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `payment_id` varchar(200) NOT NULL,
  `trx_id` varchar(200) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `payment_type` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `status` varchar(200) NOT NULL,
  `payment_execute_time` datetime NOT NULL,
  `payment_method` varchar(200) NOT NULL,
  `response` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_bkash_pay`
INSERT INTO `accounting_bkash_pay` (`id`, `invoice_id`, `payment_id`, `trx_id`, `student_id`, `year`, `course_id`, `amount`, `payment_type`, `description`, `status`, `payment_execute_time`, `payment_method`, `response`, `created_at`) VALUES("1","3","TR0011eIu67LP1742270713134","CCI9O0LVXP","2032","2024","3","1","sale","Kolom","success","2025-03-18 10:05:52","bKash","{\"paymentID\":\"TR0011eIu67LP1742270713134\",\"status\":\"success\",\"signature\":\"P2LlSUTSJy\",\"apiVersion\":\"1.2.0-beta\\/\"}","0000-00-00 00:00:00");


-- Table structure for table `accounting_cost_category_v5`
DROP TABLE IF EXISTS `accounting_cost_category_v5`;
CREATE TABLE `accounting_cost_category_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_cost_category_v5`


-- Table structure for table `accounting_cost_v5`
DROP TABLE IF EXISTS `accounting_cost_v5`;
CREATE TABLE `accounting_cost_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `amount` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `category_id` varchar(200) NOT NULL,
  `cost_by_name` varchar(500) DEFAULT NULL,
  `attachment` varchar(500) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_cost_v5`


-- Table structure for table `accounting_income_category_v5`
DROP TABLE IF EXISTS `accounting_income_category_v5`;
CREATE TABLE `accounting_income_category_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_income_category_v5`


-- Table structure for table `accounting_income_v5`
DROP TABLE IF EXISTS `accounting_income_v5`;
CREATE TABLE `accounting_income_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `amount` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `category_id` int(11) NOT NULL,
  `income_by_name` varchar(200) NOT NULL,
  `attachment` varchar(500) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_income_v5`


-- Table structure for table `accounting_log_v5`
DROP TABLE IF EXISTS `accounting_log_v5`;
CREATE TABLE `accounting_log_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_log_v5`
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("1","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:48:08\",\"payment_id\":\"22\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:39");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("2","Payment Transaction Deleted","{\"student_id\":\"2031\",\"student_name\":\"Al Imran\",\"amount\":\"50.00\",\"date\":\"2025-03-11 12:19:17\",\"payment_id\":\"1\"}","1","2025-03-11 16:59:42");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("3","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:47:32\",\"payment_id\":\"21\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:45");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("4","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:45:03\",\"payment_id\":\"20\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:47");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("5","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:41:46\",\"payment_id\":\"19\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:49");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("6","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:41:36\",\"payment_id\":\"18\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:51");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("7","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:38:17\",\"payment_id\":\"17\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:53");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("8","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:36:16\",\"payment_id\":\"16\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:55");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("9","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 14:01:38\",\"payment_id\":\"5\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 16:59:58");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("10","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:35:22\",\"payment_id\":\"15\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:00");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("11","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:35:12\",\"payment_id\":\"14\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:02");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("12","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 15:33:20\",\"payment_id\":\"13\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:04");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("13","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"1.00\",\"date\":\"2025-03-11 14:09:21\",\"payment_id\":\"12\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:05");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("14","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"1.00\",\"date\":\"2025-03-11 14:08:27\",\"payment_id\":\"11\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:08");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("15","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"1.00\",\"date\":\"2025-03-11 14:07:12\",\"payment_id\":\"10\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:10");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("16","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 14:05:42\",\"payment_id\":\"9\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:12");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("17","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 14:03:18\",\"payment_id\":\"8\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:14");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("18","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 14:02:32\",\"payment_id\":\"7\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:16");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("19","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"10.00\",\"date\":\"2025-03-11 14:02:06\",\"payment_id\":\"6\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:18");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("20","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 14:00:35\",\"payment_id\":\"4\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:20");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("21","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 14:00:07\",\"payment_id\":\"3\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:22");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("22","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 13:57:50\",\"payment_id\":\"2\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:24");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("23","Sales Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"0.00\",\"date\":\"2025-03-11 13:57:07\",\"payment_id\":\"1\",\"items\":[\"Kolom (Qty: 1, Amount: 10)\"]}","1","2025-03-11 17:00:28");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("24","Payment Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"100.00\",\"date\":\"2025-03-11 13:55:34\",\"payment_id\":\"2\"}","1","2025-03-11 17:00:31");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("25","Payment Transaction Deleted","{\"student_id\":\"2031\",\"student_name\":\"Al Imran\",\"amount\":\"50.00\",\"date\":\"2025-03-11 17:07:49\",\"payment_id\":\"3\"}","1","2025-03-11 17:12:27");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("26","Payment Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"50.00\",\"date\":\"2025-03-11 17:08:40\",\"payment_id\":\"4\"}","1","2025-03-11 17:12:30");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("27","Payment Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"100.00\",\"date\":\"2025-03-18 09:51:32\",\"payment_id\":\"2\"}","1","2025-03-19 11:10:57");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("28","Payment Transaction Deleted","{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"amount\":\"100.00\",\"date\":\"2025-03-18 09:45:25\",\"payment_id\":\"1\"}","1","2025-03-19 11:11:00");


-- Table structure for table `accounting_manual_getway_v5`
DROP TABLE IF EXISTS `accounting_manual_getway_v5`;
CREATE TABLE `accounting_manual_getway_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `qr_code_image` varchar(500) NOT NULL,
  `number` varchar(500) NOT NULL,
  `note` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_manual_getway_v5`


-- Table structure for table `accounting_particular_amount_v5`
DROP TABLE IF EXISTS `accounting_particular_amount_v5`;
CREATE TABLE `accounting_particular_amount_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` varchar(500) NOT NULL,
  `course_id` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `year` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_particular_amount_v5`
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("1","1","1","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("2","1","2","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("3","1","3","100","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("4","1","4","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("5","1","5","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("6","1","6","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("7","1","7","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("8","1","8","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("9","1","9","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("10","1","10","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("11","1","11","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("12","1","12","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("13","2","1","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("14","2","2","200","2024","2025-03-11 13:53:06");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("15","2","3","200","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("16","2","4","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("17","2","5","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("18","2","6","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("19","2","7","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("20","2","8","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("21","2","9","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("22","2","10","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("23","2","11","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("24","2","12","0","2024","2025-03-11 12:19:01");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("25","3","1","10","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("26","3","2","10","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("27","3","3","10","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("28","3","4","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("29","3","5","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("30","3","6","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("31","3","7","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("32","3","8","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("33","3","9","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("34","3","10","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("35","3","11","0","2024","2025-03-11 13:56:59");
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`) VALUES("36","3","12","0","2024","2025-03-11 13:56:59");


-- Table structure for table `accounting_particular_history_v5`
DROP TABLE IF EXISTS `accounting_particular_history_v5`;
CREATE TABLE `accounting_particular_history_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `action` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_particular_history_v5`


-- Table structure for table `accounting_particular_stock_v5`
DROP TABLE IF EXISTS `accounting_particular_stock_v5`;
CREATE TABLE `accounting_particular_stock_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` int(11) NOT NULL,
  `stock` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_particular_stock_v5`


-- Table structure for table `accounting_particular_v5`
DROP TABLE IF EXISTS `accounting_particular_v5`;
CREATE TABLE `accounting_particular_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `type` varchar(200) NOT NULL,
  `pay_lastdate` date DEFAULT NULL,
  `last_date_over_amount` varchar(20) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_particular_v5`
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("1","Admit Card Fee","one_time","0000-00-00","",NULL,"2025-03-11 12:18:20");
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("2","6 Month Tuition Fees","one_time","0000-00-00","",NULL,"2025-03-11 12:18:30");
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("3","Kolom","multi_time","0000-00-00","",NULL,"2025-03-11 13:56:37");


-- Table structure for table `accounting_payment_method_v5`
DROP TABLE IF EXISTS `accounting_payment_method_v5`;
CREATE TABLE `accounting_payment_method_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `qr_code_image` varchar(1000) NOT NULL,
  `number` varchar(500) NOT NULL,
  `note` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payment_method_v5`
INSERT INTO `accounting_payment_method_v5` (`id`, `name`, `details`, `qr_code_image`, `number`, `note`, `date`) VALUES("1","বিকাশ","","../../images/67cfd63ee2771.jpg","dfgfd","gfd","2025-03-11 12:20:53");
INSERT INTO `accounting_payment_method_v5` (`id`, `name`, `details`, `qr_code_image`, `number`, `note`, `date`) VALUES("4","Cash","","","","","2025-03-12 21:08:31");
INSERT INTO `accounting_payment_method_v5` (`id`, `name`, `details`, `qr_code_image`, `number`, `note`, `date`) VALUES("5","ক্যাশ","","","","","2025-03-12 21:08:39");


-- Table structure for table `accounting_payment_particular_v5`
DROP TABLE IF EXISTS `accounting_payment_particular_v5`;
CREATE TABLE `accounting_payment_particular_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `particular_id` int(11) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payment_particular_v5`
INSERT INTO `accounting_payment_particular_v5` (`id`, `payment_id`, `year`, `student_id`, `particular_id`, `amount`, `created_at`) VALUES("3","3","2024","2032","1","100","2025-03-19 11:11:17");


-- Table structure for table `accounting_payment_transport_v5`
DROP TABLE IF EXISTS `accounting_payment_transport_v5`;
CREATE TABLE `accounting_payment_transport_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `month` varchar(30) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payment_transport_v5`


-- Table structure for table `accounting_payment_tuition_v5`
DROP TABLE IF EXISTS `accounting_payment_tuition_v5`;
CREATE TABLE `accounting_payment_tuition_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `month` varchar(20) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payment_tuition_v5`


-- Table structure for table `accounting_payment_v5`
DROP TABLE IF EXISTS `accounting_payment_v5`;
CREATE TABLE `accounting_payment_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(50) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `registration_no` varchar(50) DEFAULT NULL,
  `total_amount` varchar(50) NOT NULL,
  `discount` varchar(50) DEFAULT NULL,
  `paid_amount` varchar(50) NOT NULL,
  `payment_date` datetime NOT NULL,
  `payment_month` int(11) NOT NULL,
  `payment_type` varchar(50) NOT NULL,
  `receive_amount` varchar(20) DEFAULT NULL,
  `due_amount` varchar(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `discount_text` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payment_v5`
INSERT INTO `accounting_payment_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `registration_no`, `total_amount`, `discount`, `paid_amount`, `payment_date`, `payment_month`, `payment_type`, `receive_amount`, `due_amount`, `created_at`, `date`, `discount_text`) VALUES("3",NULL,"2032","2024","0",NULL,"100",NULL,"100","2025-03-19 11:11:17","3","pay","100","0","2025-03-19 11:11:07","2025-03-19 11:11:17",NULL);


-- Table structure for table `accounting_payments_request_v5`
DROP TABLE IF EXISTS `accounting_payments_request_v5`;
CREATE TABLE `accounting_payments_request_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `payment_method` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `type` varchar(200) NOT NULL,
  `transaction_id` varchar(200) NOT NULL,
  `student_id` int(11) NOT NULL,
  `course` int(11) NOT NULL,
  `year` varchar(20) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `response` varchar(1000) DEFAULT NULL,
  `pay_number` varchar(200) NOT NULL,
  `previous_submit_count` int(11) NOT NULL DEFAULT 0,
  `lock_status` int(11) NOT NULL DEFAULT 0,
  `status` varchar(300) NOT NULL DEFAULT 'Pending',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_payments_request_v5`
INSERT INTO `accounting_payments_request_v5` (`id`, `invoice_id`, `description`, `payment_method`, `amount`, `type`, `transaction_id`, `student_id`, `course`, `year`, `date`, `response`, `pay_number`, `previous_submit_count`, `lock_status`, `status`) VALUES("1","2","Kolom","1","5","sale","6456","2032","3","2024","2025-03-19 11:08:49",NULL,"54645","0","0","Approved");
INSERT INTO `accounting_payments_request_v5` (`id`, `invoice_id`, `description`, `payment_method`, `amount`, `type`, `transaction_id`, `student_id`, `course`, `year`, `date`, `response`, `pay_number`, `previous_submit_count`, `lock_status`, `status`) VALUES("2","5","Kolom","1","5","sale","22222222","2032","3","2024","2025-03-19 11:09:57",NULL,"465","0","0","Approved");
INSERT INTO `accounting_payments_request_v5` (`id`, `invoice_id`, `description`, `payment_method`, `amount`, `type`, `transaction_id`, `student_id`, `course`, `year`, `date`, `response`, `pay_number`, `previous_submit_count`, `lock_status`, `status`) VALUES("3","1","Admit Card Fee","1","100","pay","12312","2032","3","2024","2025-03-19 11:11:17",NULL,"5236123","0","0","Approved");


-- Table structure for table `accounting_sell_v5`
DROP TABLE IF EXISTS `accounting_sell_v5`;
CREATE TABLE `accounting_sell_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `regi` int(11) NOT NULL,
  `particulars` text NOT NULL,
  `discount` varchar(200) NOT NULL,
  `discount_text` varchar(200) NOT NULL,
  `paid_amount` varchar(200) NOT NULL,
  `receive_amount` varchar(200) NOT NULL,
  `due_amount` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_sell_v5`
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("1","0","2032","2024","3","2032","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","10","0","2025-03-18 09:54:25");
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("2","0","2032","2024","3","2032","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","10","0","2025-03-19 11:08:49");
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("3","0","2032","2024","3","2032","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","10","0","2025-03-18 10:05:52");
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("4","0","2032","2024","3","2032","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","10","0","2025-03-18 21:17:30");
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("5","0","2032","2024","3","2032","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","10","0","2025-03-19 11:09:57");
INSERT INTO `accounting_sell_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `regi`, `particulars`, `discount`, `discount_text`, `paid_amount`, `receive_amount`, `due_amount`, `date`) VALUES("6","0","2031","2024","3","2031","[{\"particular_id\":\"3\",\"amount\":\"10\",\"quantity\":\"1\"}]","0","","10","5","5","2025-03-19 00:00:00");


-- Table structure for table `accounting_settings_sms_v5`
DROP TABLE IF EXISTS `accounting_settings_sms_v5`;
CREATE TABLE `accounting_settings_sms_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `one_time_collection` text NOT NULL,
  `multi_time_collection` text NOT NULL,
  `one_time_due_collection` varchar(2000) NOT NULL,
  `multi_time_due_collection` varchar(2000) NOT NULL,
  `due_reminder_template` varchar(2000) NOT NULL,
  `invoice_url` varchar(300) NOT NULL,
  `apiUrl` varchar(500) NOT NULL,
  `apiKey` varchar(500) NOT NULL,
  `authKey` varchar(500) NOT NULL,
  `sms_status` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_settings_sms_v5`
INSERT INTO `accounting_settings_sms_v5` (`id`, `one_time_collection`, `multi_time_collection`, `one_time_due_collection`, `multi_time_due_collection`, `due_reminder_template`, `invoice_url`, `apiUrl`, `apiKey`, `authKey`, `sms_status`, `date`) VALUES("1","সম্মানিত অভিভাবক  আপনার  পেমেন্ট  গৃহীত হয়েছে: `recive_amount` টাকা,অপরিশোধিত পরিমাণ: `due_amount` টাকা, ইনভয়েস আইডি: `payment_id` . শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` মাদরাসা আল-আশরাফ ঢা","আপনার  পেমেন্ট  গৃহীত হয়েছে: `recive_amount_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা, ইনভয়েস আইডি: `payment_id`","সম্মানিত অভিভাবক  আপনার  পেমেন্ট  গৃহীত হয়েছে: `now_payment_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা. শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` মাদরাসা আল-আশরাফ ঢা","সম্মানিত অভিভাবক  আপনার  পেমেন্ট  গৃহীত হয়েছে: `now_payment_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা  . শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` মাদরাসা আল-আশরাফ ঢা","সম্মানিত অভিভাবক শিক্ষার্থীর নাম: `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , অপরিশোধিত টাকা: `due_amount_bn`","http://localhost/webbazar_smartschool_v5","https://api-sms.webbazarbd.com//sms-v2-api.php","CPGeYE1ZgIvWPJj1716874237","6638120995","on","2025-03-15 09:04:03");


-- Table structure for table `accounting_settings_v5`
DROP TABLE IF EXISTS `accounting_settings_v5`;
CREATE TABLE `accounting_settings_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `website_name` varchar(300) NOT NULL,
  `short_name` varchar(300) NOT NULL,
  `website_name_bn` varchar(300) NOT NULL,
  `logo` varchar(300) NOT NULL,
  `watermark` varchar(300) NOT NULL,
  `address` varchar(300) NOT NULL,
  `address_bn` varchar(300) NOT NULL,
  `site_url` varchar(300) NOT NULL,
  `invoice` varchar(300) NOT NULL,
  `invoice_note` varchar(300) NOT NULL,
  `invoice_paid_mark` varchar(300) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `sslcommerz` varchar(200) NOT NULL,
  `bkash` varchar(500) NOT NULL,
  `manual_payment` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_settings_v5`
INSERT INTO `accounting_settings_v5` (`id`, `website_name`, `short_name`, `website_name_bn`, `logo`, `watermark`, `address`, `address_bn`, `site_url`, `invoice`, `invoice_note`, `invoice_paid_mark`, `currency`, `sslcommerz`, `bkash`, `manual_payment`, `date`) VALUES("1","My Daily","ওয়েব বাজার বিডি","ওয়েব বাজার বিডি","logo_1741673885_profile-pic (1).png","watermark_1741673885_logo.png","Mollapara, Mohadevpur, Naogaon","sdg","http://localhost/webbazar_smartschool_v5/","invoice_1","vgfgf","on","৳","on","on","on","2025-03-17 20:45:54");


-- Table structure for table `accounting_ssl_pay`
DROP TABLE IF EXISTS `accounting_ssl_pay`;
CREATE TABLE `accounting_ssl_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(100) NOT NULL,
  `payment_id` varchar(100) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `payment_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `status` varchar(200) NOT NULL,
  `payment_execute_time` datetime NOT NULL,
  `payment_method` varchar(200) NOT NULL,
  `response` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_ssl_pay`
INSERT INTO `accounting_ssl_pay` (`id`, `invoice_id`, `payment_id`, `student_id`, `year`, `course_id`, `amount`, `payment_type`, `description`, `status`, `payment_execute_time`, `payment_method`, `response`, `created_at`) VALUES("1","1","SSLCZ_1_67d8ec4e6907e","2032","2024","3","100.00","pay","Admit Card Fee","success","2025-03-18 09:45:25","SSLCommerz","{\"tran_id\":\"SSLCZ_1_67d8ec4e6907e\",\"val_id\":\"25031894524ShfeyvSER8Azdnd\",\"amount\":\"100.00\",\"card_type\":\"BKASH-BKash\",\"store_amount\":\"97.50\",\"card_no\":\"\",\"bank_tran_id\":\"25031894524mPjlveVsHowOc6L\",\"status\":\"VALID\",\"tran_date\":\"2025-03-18 09:45:21\",\"error\":\"\",\"currency\":\"BDT\",\"card_issuer\":\"BKash Mobile Banking\",\"card_brand\":\"MOBILEBANKING\",\"card_sub_brand\":\"Classic\",\"card_issuer_country\":\"Bangladesh\",\"card_issuer_country_code\":\"BD\",\"store_id\":\"editb66a9f16f208b7\",\"verify_sign\":\"e2bc5d75817e2dd88","0000-00-00 00:00:00");
INSERT INTO `accounting_ssl_pay` (`id`, `invoice_id`, `payment_id`, `student_id`, `year`, `course_id`, `amount`, `payment_type`, `description`, `status`, `payment_execute_time`, `payment_method`, `response`, `created_at`) VALUES("2","2","SSLCZ_2_67d8edbd7e5fc","2032","2024","3","100.00","due_pay","6 Month Tuition Fees","success","2025-03-18 09:51:32","SSLCommerz","{\"tran_id\":\"SSLCZ_2_67d8edbd7e5fc\",\"val_id\":\"2503189513206zHpiHBBbGlNKf\",\"amount\":\"100.00\",\"card_type\":\"BKASH-BKash\",\"store_amount\":\"97.50\",\"card_no\":\"\",\"bank_tran_id\":\"25031895132re7nnCYH1wNqeaH\",\"status\":\"VALID\",\"tran_date\":\"2025-03-18 09:51:28\",\"error\":\"\",\"currency\":\"BDT\",\"card_issuer\":\"BKash Mobile Banking\",\"card_brand\":\"MOBILEBANKING\",\"card_sub_brand\":\"Classic\",\"card_issuer_country\":\"Bangladesh\",\"card_issuer_country_code\":\"BD\",\"store_id\":\"editb66a9f16f208b7\",\"verify_sign\":\"e7974e39f75ed6042","0000-00-00 00:00:00");
INSERT INTO `accounting_ssl_pay` (`id`, `invoice_id`, `payment_id`, `student_id`, `year`, `course_id`, `amount`, `payment_type`, `description`, `status`, `payment_execute_time`, `payment_method`, `response`, `created_at`) VALUES("3","1","SSLCZ_1_67d8ee6a69383","2032","2024","3","5.00","sale","Kolom","success","2025-03-18 09:54:25","SSLCommerz","{\"tran_id\":\"SSLCZ_1_67d8ee6a69383\",\"val_id\":\"25031895425bDhUxOuxpgQq5ms\",\"amount\":\"5.00\",\"card_type\":\"BKASH-BKash\",\"store_amount\":\"4.88\",\"card_no\":\"\",\"bank_tran_id\":\"250318954250Kjb0RhOrLAM1dd\",\"status\":\"VALID\",\"tran_date\":\"2025-03-18 09:54:21\",\"error\":\"\",\"currency\":\"BDT\",\"card_issuer\":\"BKash Mobile Banking\",\"card_brand\":\"MOBILEBANKING\",\"card_sub_brand\":\"Classic\",\"card_issuer_country\":\"Bangladesh\",\"card_issuer_country_code\":\"BD\",\"store_id\":\"editb66a9f16f208b7\",\"verify_sign\":\"b0b543cfc4b03f2aac37","0000-00-00 00:00:00");


-- Table structure for table `accounting_transaction_v5`
DROP TABLE IF EXISTS `accounting_transaction_v5`;
CREATE TABLE `accounting_transaction_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `receive_amount` varchar(500) NOT NULL,
  `payment_method_id` varchar(110) NOT NULL,
  `payment_id` int(11) NOT NULL,
  `type` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_transaction_v5`
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("2","0","2032","2024","3","100","1","2","particular","2025-03-18 09:46:51");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("4","0","2032","2024","3","5","1","1","sell","2025-03-18 09:53:43");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("5","0","2032","2024","3","2","1","2","sell","2025-03-18 09:53:54");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("6",NULL,"2032","2024","3","5.00","SSLCommerz","1","sale","2025-03-18 09:54:25");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("7","0","2032","2024","3","9","1","3","sell","2025-03-18 10:01:57");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("9","0","2032","2024","3","9","1","4","sell","2025-03-18 10:05:02");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("10",NULL,"2032","2024","3","1","bKash","3","sale","2025-03-18 10:05:52");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("11",NULL,"2032","2024","3","1","1","4","sell","2025-03-18 21:17:30");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("12",NULL,"2032","2024","3","1","1","2","sell","2025-03-18 21:20:25");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("13",NULL,"2032","2024","3","1","1","2","sell","2025-03-18 21:21:37");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("14",NULL,"2032","2024","3","1","1","2","sell","2025-03-18 21:22:13");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("15","0","2032","2024","3","5","1","5","sell","2025-03-19 10:53:40");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("16","0","2031","2024","3","5","1","6","sell","2025-03-19 10:53:56");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("17",NULL,"2032","2024","0","5","1","2","sale_due","2025-03-19 11:08:49");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("18",NULL,"2032","2024","0","5","1","5","sale_due","2025-03-19 11:09:57");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `created_at`) VALUES("19",NULL,"2032","2024","0","100","1","3","particular","2025-03-19 11:11:17");


-- Table structure for table `accounting_transport_fee_v5`
DROP TABLE IF EXISTS `accounting_transport_fee_v5`;
CREATE TABLE `accounting_transport_fee_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_transport_fee_v5`


-- Table structure for table `accounting_tuition_fee_v5`
DROP TABLE IF EXISTS `accounting_tuition_fee_v5`;
CREATE TABLE `accounting_tuition_fee_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(500) NOT NULL,
  `year` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `accounting_tuition_fee_v5`


-- Table structure for table `activities_student_v3`
DROP TABLE IF EXISTS `activities_student_v3`;
CREATE TABLE `activities_student_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `activity_status` varchar(200) NOT NULL,
  `course` varchar(200) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `year` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `activities_student_v3`
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("1","2031","5","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("2","2032","7","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("3","2033","8","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("4","2031","6","3","44","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("5","2032","7","3","44","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("6","2033","8","3","44","2025-04-04","2024");


-- Table structure for table `activities_v3`
DROP TABLE IF EXISTS `activities_v3`;
CREATE TABLE `activities_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `details` varchar(2000) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `activities_v3`
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("5","ভালো","ভালো","2024-12-27 12:04:20");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("6","উত্তম","উত্তম","2024-12-27 12:04:29");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("7","খারাপ","খারাপ","2024-12-27 12:04:38");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("8","খুবই খারাপ","খুবই খারাপ","2024-12-27 12:04:45");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("9","Others","Others","2025-01-11 14:50:19");


-- Table structure for table `add_registation_number_update_info`
DROP TABLE IF EXISTS `add_registation_number_update_info`;
CREATE TABLE `add_registation_number_update_info` (
  `id` int(11) NOT NULL,
  `log_type` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `title` varchar(100) NOT NULL,
  `creator_by` int(30) NOT NULL,
  `creator_by_sub_user` int(11) NOT NULL,
  `is_read` text NOT NULL,
  `is_red_sub_user` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `add_registation_number_update_info`
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("0","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"1\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-12-19 07:15:08","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("30","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"1\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-11-04 16:49:41","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("31","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"4\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-11-30 08:02:41","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("32","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"000020\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-27 02:24:01","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("33","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"20253\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-27 02:24:28","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("34","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"20243\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-29 10:47:35","user");


-- Table structure for table `admin_notice`
DROP TABLE IF EXISTS `admin_notice`;
CREATE TABLE `admin_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_title` varchar(255) DEFAULT NULL,
  `notice_desc` longtext DEFAULT NULL,
  `notice_link` varchar(255) DEFAULT NULL,
  `teacher_action` varchar(255) DEFAULT NULL,
  `course_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `start_date` varchar(255) DEFAULT NULL,
  `update_date` timestamp NULL DEFAULT current_timestamp(),
  `image` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_notice`
INSERT INTO `admin_notice` (`id`, `notice_title`, `notice_desc`, `notice_link`, `teacher_action`, `course_id`, `user_id`, `start_date`, `update_date`, `image`, `status`) VALUES("15","পরীক্ষার নোটিশ প্রথম সাময়িক পরীক্ষার","প্রিয় অভিভাবক গন আসসালামু আলাইকুম, সকলের অবগতির জন্য জানানো যাচ্ছে আগামী ৩০/০১/২০২৪ তারিখে সকাল ১০টায় পরীক্ষা অনুষ্ঠিত হইবে। তাই দ্রুত বকেয়া টাকা ও প্রবেশ ফি পরিশোধ করুন অনলাইনে। 
\n
\nধন্যবাদান্তে পরিচালক",NULL,"","3"," ","1728453200","2024-10-04 08:04:32","2248c6bf0a.png","1");


-- Table structure for table `admission_form_tamplete`
DROP TABLE IF EXISTS `admission_form_tamplete`;
CREATE TABLE `admission_form_tamplete` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(250) NOT NULL,
  `file_name` varchar(250) DEFAULT NULL,
  `form_no` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `admission_form_tamplete`
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("2","
\nADMISSION FORM - 1 (English)",NULL,"1","1");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("3","ADMISSION FORM - 2 (Bangla)",NULL,"2","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("4","ADMISSION FORM - 3",NULL,"3","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("5","ADMISSION FORM - 4",NULL,"4","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("6","ADMISSION FORM - 5",NULL,"5","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("7","ADMISSION FORM - 6",NULL,"6","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("8","ADMISSION FORM - 7",NULL,"7","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("9","ADMISSION FORM - 8",NULL,"8","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("10","
\nADMISSION FORM - 9 (English)",NULL,"9","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("11","ADMISSION FORM - 10 (Bangla)",NULL,"10","0");


-- Table structure for table `admission_switch`
DROP TABLE IF EXISTS `admission_switch`;
CREATE TABLE `admission_switch` (
  `id` int(10) NOT NULL,
  `msg` varchar(250) NOT NULL,
  `admission_start_date` varchar(250) DEFAULT NULL,
  `admission_last_date` varchar(250) DEFAULT NULL,
  `type` varchar(100) NOT NULL,
  `status` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admission_switch`
INSERT INTO `admission_switch` (`id`, `msg`, `admission_start_date`, `admission_last_date`, `type`, `status`) VALUES("1","আগামী ৩০ জুন ভর্তি ফরম পুরণ করা যাবে সকাল ১০ টা হতে ","1716681600","1748219400","student","1");
INSERT INTO `admission_switch` (`id`, `msg`, `admission_start_date`, `admission_last_date`, `type`, `status`) VALUES("2","Contact Admin For Teacher Registration","1703039220","1766197620","teacher","1");


-- Table structure for table `admit_activation`
DROP TABLE IF EXISTS `admit_activation`;
CREATE TABLE `admit_activation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zi_section` int(11) DEFAULT NULL,
  `zi_year` int(11) DEFAULT NULL,
  `zi_session` int(11) DEFAULT NULL,
  `zi_class` int(11) DEFAULT NULL,
  `z_exam_name` int(11) DEFAULT NULL,
  `z_regi_id` int(11) DEFAULT NULL,
  `z_shift` int(11) DEFAULT NULL,
  `z_group` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admit_activation`
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("13","6","2023","3","3","21","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("14","6","2023","3","3","21","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("15","6","2023","3","3","21","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("16","6","2023","3","3","21","47","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("17","6","2023","3","3","23","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("18","6","2023","3","3","23","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("19","6","2023","3","3","23","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("20","6","2023","3","3","23","47","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("21","6","2023","3","3","21","2","1","2","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("22","6","2023","3","3","29","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("23","6","2023","3","3","29","0","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("24","6","2023","3","3","29","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("25","6","2024","4","3","21","7","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("26","6","2024","4","3","21","6","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("27","6","2024","4","3","21","5","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("28","6","2024","4","3","21","4","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("29","6","2024","4","3","21","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("30","6","2024","4","3","21","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("31","6","2024","4","3","21","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("32","6","2024","4","3","21","0","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("33","6","2024","4","3","21","9","1","1","1");


-- Table structure for table `admit_card_download`
DROP TABLE IF EXISTS `admit_card_download`;
CREATE TABLE `admit_card_download` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `start_date` varchar(250) NOT NULL,
  `end_date` varchar(250) NOT NULL,
  `class` varchar(250) NOT NULL,
  `branch` varchar(250) NOT NULL,
  `year` varchar(250) NOT NULL,
  `session` varchar(250) NOT NULL,
  `section` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `exam_name` longtext NOT NULL,
  `description_code` varchar(100) NOT NULL,
  `particular_id` int(11) NOT NULL,
  `payment_month` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admit_card_download`
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("9","2025-03-03","2025-04-06","3","1","2024","4","6","3","1st Examination-2024","99999","50","2025-03-01");


-- Table structure for table `admit_card_exam_name_entry`
DROP TABLE IF EXISTS `admit_card_exam_name_entry`;
CREATE TABLE `admit_card_exam_name_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bangla` varchar(255) DEFAULT NULL,
  `english` varchar(255) DEFAULT NULL,
  `exam_center_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `admit_card_exam_name_entry`
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("2","প্রথম সাময়িক পরীক্ষা/২০২৪","First Provisional Examination/2024","ঢাকা কলেজ,ঢাকা");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("3","প্রথম","First Provisional ","আমার ওয়েব বাজার বিডি");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("4","","","");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("5","","","");


-- Table structure for table `admit_id_card_template`
DROP TABLE IF EXISTS `admit_id_card_template`;
CREATE TABLE `admit_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(12) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `admit_id_card_template`
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1733536512_1.admit_card_english_1.png","1","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1728004523_2.admit_card_bangla_2.png","2","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1728004969_3.admit_card_bangla_3.png","3","1","0","0","1");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1704964506_admit_card_english_4.png","4","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("7","image/template_1733499117_5.admit_card_bangla_5.png","5","1","0","0","0");


-- Table structure for table `all_jakat`
DROP TABLE IF EXISTS `all_jakat`;
CREATE TABLE `all_jakat` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `details` varchar(250) NOT NULL,
  `create_date` varchar(100) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `amount_status` varchar(100) DEFAULT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `all_jakat`


-- Table structure for table `all_tax`
DROP TABLE IF EXISTS `all_tax`;
CREATE TABLE `all_tax` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `percent` int(10) NOT NULL,
  `details` varchar(250) DEFAULT NULL,
  `create_date` varchar(100) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `amount_status` varchar(100) DEFAULT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `all_tax`


-- Table structure for table `api`
DROP TABLE IF EXISTS `api`;
CREATE TABLE `api` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(250) DEFAULT NULL,
  `api_key` varchar(250) NOT NULL,
  `api_auth` varchar(250) NOT NULL,
  `domain` varchar(250) DEFAULT NULL,
  `user_id` int(20) NOT NULL,
  `expire_date` varchar(250) NOT NULL,
  `status` varchar(250) NOT NULL DEFAULT 'on',
  `device_serial_key` varchar(250) NOT NULL,
  `default_request` varchar(250) NOT NULL DEFAULT 'localhost',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `api`


-- Table structure for table `api_dashboards`
DROP TABLE IF EXISTS `api_dashboards`;
CREATE TABLE `api_dashboards` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(250) NOT NULL,
  `api_auth` varchar(250) NOT NULL,
  `last_update` varchar(250) NOT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  `email_status` int(10) NOT NULL,
  `expire_date` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 0,
  `user_name` varchar(250) NOT NULL,
  `user_email` varchar(250) NOT NULL,
  `user_mobile` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `api_dashboards`


-- Table structure for table `applications_type_v3`
DROP TABLE IF EXISTS `applications_type_v3`;
CREATE TABLE `applications_type_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `applications_type_v3`
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("1","Sick leave","sick leave","2025-01-06 14:28:19");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("2","Tour leave","Tour leave","2025-01-06 14:28:32");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("3","Others","Others","2025-01-06 14:28:40");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("4","Family Problem","Family Problem","2025-01-06 14:31:13");


-- Table structure for table `attendance`
DROP TABLE IF EXISTS `attendance`;
CREATE TABLE `attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_std` int(11) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `class_std` int(11) DEFAULT NULL,
  `subject` int(11) DEFAULT NULL,
  `atten_date` varchar(255) DEFAULT NULL,
  `std_id` varchar(11) NOT NULL,
  `std_time` int(11) NOT NULL,
  `present_status` int(11) DEFAULT NULL COMMENT '1=present, 0= Absent, 2=Unkonw',
  `teacher_id` varchar(100) DEFAULT NULL,
  `admin_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance`
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("16","1","2024","3","15","2024-08-01","Md_871165","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("17","1","2024","3","15","2024-08-01","Md_901169","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("18","1","2024","3","15","2024-08-01","Md_127170","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("19","1","2024","3","15","2024-08-01","Md_349171","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("20","1","2024","3","15","2024-08-01","Md_630172","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("21","1","2024","3","15","2024-08-01","Md_571173","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("22","1","2024","3","15","2024-08-01","Md_57117345","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("23","1","2024","3","15","2024-08-01","Md_811175","1722523102","2","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("24","1","2024","3","15","2024-08-01","Md_575176","1722523102","1","1",NULL);
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `admin_id`) VALUES("25","1","2024","3","17","2024-12-02","Md_1691344","1733140000","2",NULL,"1");


-- Table structure for table `attendance_custom_sms`
DROP TABLE IF EXISTS `attendance_custom_sms`;
CREATE TABLE `attendance_custom_sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `person_type` varchar(250) NOT NULL,
  `message_type` varchar(250) NOT NULL,
  `lan_type` varchar(250) NOT NULL,
  `message` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance_custom_sms`
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("3","staff","present","en_bn","new message  ss","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("4","staff","late","en_bn","আমার সোনার বাংলা","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("5","staff","out","en_bn","আমার সোনার বাংলা student out","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("6","student","present","en_bn","প্রিয় অভিভাবক, আপনার সন্তান স্কুলে উপস্থিত হয়েছে। ","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("7","student","out","en_bn","প্রিয় অভিভাবক, আপনার সন্তান স্কুলে থেকে প্রস্থান করেছে।","1");


-- Table structure for table `attendance_history`
DROP TABLE IF EXISTS `attendance_history`;
CREATE TABLE `attendance_history` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `attendance_id` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `person_type` varchar(250) NOT NULL,
  `date_time` varchar(250) NOT NULL,
  `date` varchar(250) NOT NULL,
  `time` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=598333 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance_history`
INSERT INTO `attendance_history` (`id`, `attendance_id`, `person_id`, `person_type`, `date_time`, `date`, `time`) VALUES("598332","955","172","student","2024-05-02T09:31:04","2024-05-02","09:31:04");


-- Table structure for table `attendance_live_notice`
DROP TABLE IF EXISTS `attendance_live_notice`;
CREATE TABLE `attendance_live_notice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `notice` varchar(250) NOT NULL,
  `date` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance_live_notice`
INSERT INTO `attendance_live_notice` (`id`, `notice`, `date`, `status`) VALUES("7","শুভ উদ্বোধন ২০২৪  :: আপনারা দেখছেন ওয়েব বাজার বিডির ডিজিটাল হাজিরা মেশিন লাইভ সফটওয়্যার ডাসবোড......",NULL,"1");
INSERT INTO `attendance_live_notice` (`id`, `notice`, `date`, `status`) VALUES("8","শুভ উদ্বোধন ২০২৪ :: আপনারা দেখছেন ওয়েব বাজার বিডির ডিজিটাল হাজিরা মেশিন লাইভ সফটওয়্যার ডাসবোড......",NULL,"1");


-- Table structure for table `attendance_report`
DROP TABLE IF EXISTS `attendance_report`;
CREATE TABLE `attendance_report` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `history_id` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `person_type` varchar(250) NOT NULL,
  `date_time` varchar(250) NOT NULL,
  `date` varchar(250) NOT NULL,
  `time` varchar(250) NOT NULL,
  `in_out_status` varchar(250) NOT NULL,
  `sms_status` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance_report`


-- Table structure for table `attendance_sms_config`
DROP TABLE IF EXISTS `attendance_sms_config`;
CREATE TABLE `attendance_sms_config` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `sms_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `attendance_sms_config`
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("37","student","165","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("40","student","169","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("45","teacher","40","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("46","teacher","48","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("50","staff","11","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("51","staff","12","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("52","student","170","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("53","student","171","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("54","student","172","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("55","student","173","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("56","student","174","0");


-- Table structure for table `baner`
DROP TABLE IF EXISTS `baner`;
CREATE TABLE `baner` (
  `id` int(10) NOT NULL,
  `banner_name` varchar(250) DEFAULT NULL,
  `logo_name` varchar(250) DEFAULT NULL,
  `title` varchar(250) DEFAULT NULL,
  `adminssion_form_baner_bn` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `adminssion_form_baner_en` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `favicon_icons` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `baner`
INSERT INTO `baner` (`id`, `banner_name`, `logo_name`, `title`, `adminssion_form_baner_bn`, `adminssion_form_baner_en`, `favicon_icons`) VALUES("1","1719277892_banner.jpg","90.png","ওয়েব বাজার বিডি স্মার্ট স্কুল","1719277882_banner.jpg","1719277887_banner.jpg","1719277907_user_pic_d.png");


-- Table structure for table `baner_text`
DROP TABLE IF EXISTS `baner_text`;
CREATE TABLE `baner_text` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `baner` varchar(250) DEFAULT NULL,
  `text` varchar(250) DEFAULT NULL,
  `sms` text CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `baner_text`
INSERT INTO `baner_text` (`id`, `baner`, `text`, `sms`) VALUES("1","1719277867.jpg","ওয়েব বাজার বিডি স্মার্ট স্কুল","Your Payment Received: `amount_bn` TK, Unpaid Amount: `unpaid_amount_bn` TK, Invoice ID: `invoice_id_bn` . Student Name: `student_name_bn`,  Student ID: `student_id_bn` ,  Check Invoice: `url_check` ");


-- Table structure for table `bank_invoice`
DROP TABLE IF EXISTS `bank_invoice`;
CREATE TABLE `bank_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_id` int(20) NOT NULL DEFAULT 0,
  `bank_name` varchar(100) DEFAULT NULL,
  `billing_type` varchar(100) DEFAULT NULL,
  `self_type` varchar(20) DEFAULT 'self',
  `ac_no` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) DEFAULT NULL,
  `total_amount` int(20) DEFAULT 0,
  `discount` int(20) DEFAULT 0,
  `due` int(20) DEFAULT 0,
  `paid_amount` int(20) DEFAULT 0,
  `billing_time` varchar(100) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `add_author` longtext DEFAULT NULL,
  `update_author` longtext DEFAULT NULL,
  `check_update` int(20) DEFAULT 0,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bank_invoice`
INSERT INTO `bank_invoice` (`id`, `bank_id`, `bank_name`, `billing_type`, `self_type`, `ac_no`, `name`, `mobile`, `discription`, `reciept`, `total_amount`, `discount`, `due`, `paid_amount`, `billing_time`, `add_date`, `update_date`, `add_author`, `update_author`, `check_update`, `d_status`) VALUES("44","2","Dutch-Bangla","deposite","self","44447854","Dutch-Bangla","01713728112","01713728112","none","0","0","0","200","2025-Mar-16:09:51:17AM","2025-03-16","2025-03-16","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742097077\"}","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742097077\"}","0","1");


-- Table structure for table `bank_list`
DROP TABLE IF EXISTS `bank_list`;
CREATE TABLE `bank_list` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(200) DEFAULT NULL,
  `bank_account` varchar(200) DEFAULT NULL,
  `holder_name` varchar(100) DEFAULT NULL,
  `bank_mobile` varchar(250) DEFAULT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bank_list`
INSERT INTO `bank_list` (`id`, `bank_name`, `bank_account`, `holder_name`, `bank_mobile`, `balance`) VALUES("2","Dutch-Bangla","44447854","WebBazarBD","01717452764","5335");


-- Table structure for table `batch`
DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (
  `betch_id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` varchar(255) DEFAULT NULL,
  `start_end_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `end_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL COMMENT '0= false, 1 start',
  PRIMARY KEY (`betch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `batch`
INSERT INTO `batch` (`betch_id`, `batch_name`, `start_end_time`, `end_time`, `status`) VALUES("6","A1","09:00","10:00","1");


-- Table structure for table `billing_invoice`
DROP TABLE IF EXISTS `billing_invoice`;
CREATE TABLE `billing_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `billing_name` varchar(100) DEFAULT NULL,
  `billing_type` varchar(100) DEFAULT NULL,
  `billing_id` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) DEFAULT NULL,
  `total_amount` varchar(100) DEFAULT NULL,
  `discount` varchar(100) DEFAULT '0',
  `due` int(20) DEFAULT 0,
  `paid_amount` varchar(100) DEFAULT '0',
  `billing_time` varchar(100) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `add_author` longtext DEFAULT NULL,
  `update_author` longtext DEFAULT NULL,
  `check_update` varchar(100) DEFAULT '0',
  `d_status` varchar(100) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `billing_invoice`
INSERT INTO `billing_invoice` (`id`, `billing_name`, `billing_type`, `billing_id`, `name`, `mobile`, `discription`, `reciept`, `total_amount`, `discount`, `due`, `paid_amount`, `billing_time`, `add_date`, `update_date`, `add_author`, `update_author`, `check_update`, `d_status`) VALUES("85","on-time","income","0","Dhaka-Chittagong","01713728112","01713728112","1742096626_5525.png","80.00","20","0","60","2025-Mar-16:09:43:46AM","2025-03-15","2025-03-15","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096626\"}","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096626\"}","0","1");
INSERT INTO `billing_invoice` (`id`, `billing_name`, `billing_type`, `billing_id`, `name`, `mobile`, `discription`, `reciept`, `total_amount`, `discount`, `due`, `paid_amount`, `billing_time`, `add_date`, `update_date`, `add_author`, `update_author`, `check_update`, `d_status`) VALUES("86","on-time","income","0","Dhaka-Chittagong","01713728112","01713728112","1742096909_2612.png","120.00","20","0","100","2025-Mar-16:09:48:29AM","2025-03-16","2025-03-16","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096909\"}","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096909\"}","0","1");
INSERT INTO `billing_invoice` (`id`, `billing_name`, `billing_type`, `billing_id`, `name`, `mobile`, `discription`, `reciept`, `total_amount`, `discount`, `due`, `paid_amount`, `billing_time`, `add_date`, `update_date`, `add_author`, `update_author`, `check_update`, `d_status`) VALUES("87","categories","expense","16","Dhaka-Chittagong","01713728112","01713728112","none","300.00","10","0","290","2025-Mar-16:09:49:56AM","2025-03-16","2025-03-16","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096996\"}","{\"id\":\"1\",\"username\":\"admin\",\"password\":\"123456\",\"name\":\"admin\",\"emailid\":\"webbazarbd24@gmail.com\",\"lastlogin\":\"2021-10-31 02:14:44\",\"mobile\":\"01713728112\",\"ur_birthday\":\"2021-08-2\",\"solid_pass\":\"123456\",\"type\":\"admin\",\"store_time\":\"1742096996\"}","0","1");


-- Table structure for table `bkash_token`
DROP TABLE IF EXISTS `bkash_token`;
CREATE TABLE `bkash_token` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` longtext NOT NULL,
  `create_time` varchar(250) NOT NULL,
  `expire_time` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bkash_token`
INSERT INTO `bkash_token` (`id`, `token`, `create_time`, `expire_time`) VALUES("23","eyJraWQiOiJEWXd6RU9Fd3h5Q3lkRVwvUnJZU1BOcGk5MENBQkVBeHZ0bUs1QXQ4XC9oaVk9IiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIxN2Y2NGVkNC0wMjkxLTRlNDUtYjlhYS1kMWVkYzQ5YWVmZTYiLCJhdWQiOiJrNW1xNmJlaWs0aWR2ZDkxcDRmdGV0cHYzIiwiZXZlbnRfaWQiOiI4MjZlYTU4Ny0xMTcxLTQ4ZjctYWZkYi0xZDMxMWY4NjM4YjQiLCJ0b2tlbl91c2UiOiJpZCIsImF1dGhfdGltZSI6MTc0MzIyNjU1OSwiaXNzIjoiaHR0cHM6XC9cL2NvZ25pdG8taWRwLmFwLXNvdXRoZWFzdC0xLmFtYXpvbmF3cy5jb21cL2FwLXNvdXRoZWFzdC0xX1QzVktDZzJoeSIsImNvZ25pdG86dXNlcm5hbWUiOiIwMTcxMDQxNDMwOCIsImV4cCI6MTc0MzIzMDE1OSwiaWF0IjoxNzQzMjI2NTU5fQ.SX2JlZ__L4_fVzfkYVvv0kjLn3bCIorH6c7zNt-WqasIrUVRmYlRgwlNEudRpS9vdMGg67GS1lR7uNGPOq44tpyiAzzwxeokDSjt0JhceMkS1LHy_BVNG0Iibn0APbOv0mP8AYXK2j2D6M9Jvkgwj10RsfaGcTspkVDScuABzXJI_9Buopw0iORgKVL3UWsenP1a88XLBUfgOj995jN6Tbqg6Om0DWDVJBXJ1ABFzrB3AcIEFN8AVYzNbZl3DZabYdy9Ff-RGEow642NqgBvaCnUhl0ZLTiWsmt9Vkfz5KCbGvLIEIusQkpM5gUS7s6N0iyM2GeEZ2ZhnfEeAiJ9sA","1743226556","1743230036");


-- Table structure for table `board_name`
DROP TABLE IF EXISTS `board_name`;
CREATE TABLE `board_name` (
  `id` int(20) NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `bn_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `board_name`
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("1","Barisal",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("2","Chattogram","");
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("3","Cumilla",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("4","Dhaka",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("5","Dinajpur",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("6","Jashore",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("7","Mymensingh",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("8","Rajshahi",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("9","Sylhet",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("10","Madrasah",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("11","Technical",NULL);


-- Table structure for table `branch`
DROP TABLE IF EXISTS `branch`;
CREATE TABLE `branch` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `branch` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `group_n_bangla` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `branch`
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("1","General","","General","0","সাধারন");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("5","Humanities",NULL,"Humanities","0","মানবিক");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("6","Commerce",NULL,"Commerce","0","বাণিজ্য ");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("7","Science",NULL,"Science","0","বিজ্ঞান ");


-- Table structure for table `categories`
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `c_name` varchar(250) DEFAULT NULL,
  `c_type` varchar(100) DEFAULT NULL,
  `c_amount` int(20) DEFAULT NULL,
  `c_add` varchar(100) DEFAULT NULL,
  `c_update` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `categories`
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("14","Official Stationary","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("15","Photocopy","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("16","Exam","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("17","Electricity","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("18","Travel","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("19","Mobile","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("20","Computer","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("21","Foundation","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("22","AC","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("23","Program","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("24","Dress","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("25","Edu.Equipment","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("26","Publication","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("27","Repair","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("28","House rent","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("29","Transport","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("30","Aca.Food","expense","0","2024-06-14","2024-06-14");


-- Table structure for table `category`
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(250) DEFAULT NULL,
  `category_purpose` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `category`


-- Table structure for table `certificate_id_card_template`
DROP TABLE IF EXISTS `certificate_id_card_template`;
CREATE TABLE `certificate_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `certificate_id_card_template`
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1728454088_basic_certificate -01.png","1","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1728454092_basic_certificate -02.png","2","1","0","0","1");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1728454096_basic_certificate -03.png","3","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1728454099_basic_certificate -04.png","4","1","0","0","0");


-- Table structure for table `class_routine`
DROP TABLE IF EXISTS `class_routine`;
CREATE TABLE `class_routine` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `class` varchar(100) NOT NULL,
  `s_group` varchar(100) DEFAULT NULL,
  `s_section` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `session` varchar(100) DEFAULT NULL,
  `year` varchar(100) DEFAULT NULL,
  `routine_headline` longtext DEFAULT NULL,
  `routine_file` varchar(250) DEFAULT NULL,
  `add_date` varchar(250) DEFAULT NULL,
  `update_date` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `class_routine`
INSERT INTO `class_routine` (`id`, `class`, `s_group`, `s_section`, `shift`, `session`, `year`, `routine_headline`, `routine_file`, `add_date`, `update_date`) VALUES("8","1","1","6","3","4","2024","প্রথম শ্রেণীর ক্লাস রুটন-২০২৪","Class routine 21.01.2018.pdf","2024-11-17 18:03:05",NULL);


-- Table structure for table `class_schedule_student`
DROP TABLE IF EXISTS `class_schedule_student`;
CREATE TABLE `class_schedule_student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `t_id` varchar(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `contact` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `value_day` varchar(255) DEFAULT NULL,
  `value_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `room_name` varchar(255) DEFAULT NULL,
  `course` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `subject_time` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `class_schedule_student`
INSERT INTO `class_schedule_student` (`id`, `t_id`, `name`, `contact`, `value_day`, `value_time`, `room_name`, `course`, `subject`, `subject_time`) VALUES("62","48","Md Ashraful Islam","01717452764","Saturday,Sunday,Monday","4","1","12","26","00:00");
INSERT INTO `class_schedule_student` (`id`, `t_id`, `name`, `contact`, `value_day`, `value_time`, `room_name`, `course`, `subject`, `subject_time`) VALUES("64","48","Md Ashraful Islam","01717452764","Saturday,Sunday,Monday","6","1","5","27","09:00");


-- Table structure for table `class_section`
DROP TABLE IF EXISTS `class_section`;
CREATE TABLE `class_section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_name` varchar(255) DEFAULT NULL,
  `class_section_name_bn` varchar(250) DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `class_section`
INSERT INTO `class_section` (`id`, `class_section_name`, `class_section_name_bn`, `delete_status`) VALUES("6","A","এ","0");
INSERT INTO `class_section` (`id`, `class_section_name`, `class_section_name_bn`, `delete_status`) VALUES("8","B","বি","0");


-- Table structure for table `class_test_exam`
DROP TABLE IF EXISTS `class_test_exam`;
CREATE TABLE `class_test_exam` (
  `mark_id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) DEFAULT NULL,
  `s_year` int(11) DEFAULT NULL,
  `course` int(11) DEFAULT NULL,
  `subject` int(11) DEFAULT NULL,
  `exam_name` varchar(255) DEFAULT NULL,
  `exam_key` varchar(100) DEFAULT NULL,
  `regi_ids` varchar(100) DEFAULT NULL,
  `std_mark` float DEFAULT NULL,
  `exam_status` int(11) DEFAULT NULL,
  `subject_mark` float DEFAULT NULL,
  `class_section_name` int(11) DEFAULT NULL,
  `shift_name` int(11) DEFAULT NULL,
  `academic_year_name_bn` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`mark_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `class_test_exam`
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("48","1","2024","12","26","Modal","1711350705_544418686","1","85",NULL,"100","6","1","4","2024-03-25 13:11:57");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("49","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","8","95",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("50","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","9","85",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("51","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","7","90",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("52","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","6","85",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("53","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","5","80",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("54","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","4","85",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("55","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","3","35",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("56","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","1","30",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("57","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","2","70",NULL,"100","6","1","4","2024-06-14 06:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("58","1","2024","1","43","Test Resuls-2024","1731770658_846665122","15","80",NULL,"100","6","3","4","2024-11-16 21:24:49");


-- Table structure for table `color_picker`
DROP TABLE IF EXISTS `color_picker`;
CREATE TABLE `color_picker` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `left_ber_bg` varchar(250) NOT NULL,
  `left_ber_text` varchar(250) NOT NULL,
  `top_ber_bg` varchar(250) NOT NULL,
  `top_ber_text` varchar(250) NOT NULL,
  `card_1_bg` varchar(11) NOT NULL,
  `card_2_bg` varchar(11) NOT NULL,
  `card_3_bg` varchar(11) NOT NULL,
  `card_4_bg` varchar(11) NOT NULL,
  `card_5_bg` varchar(11) NOT NULL,
  `card_6_bg` varchar(11) NOT NULL,
  `card_7_bg` varchar(11) NOT NULL,
  `card_8_bg` varchar(11) NOT NULL,
  `card_9_bg` varchar(11) NOT NULL,
  `card_10_bg` varchar(11) NOT NULL,
  `card_11_bg` varchar(11) NOT NULL,
  `card_12_bg` varchar(11) NOT NULL,
  `card_13_bg` varchar(11) NOT NULL,
  `card_14_bg` varchar(11) NOT NULL,
  `card_15_bg` varchar(11) NOT NULL,
  `card_1_text` varchar(20) NOT NULL,
  `card_2_text` varchar(20) NOT NULL,
  `card_3_text` varchar(20) NOT NULL,
  `card_4_text` varchar(20) NOT NULL,
  `card_5_text` varchar(20) NOT NULL,
  `card_6_text` varchar(20) NOT NULL,
  `card_7_text` varchar(20) NOT NULL,
  `card_8_text` varchar(20) NOT NULL,
  `card_9_text` varchar(20) NOT NULL,
  `card_10_text` varchar(20) NOT NULL,
  `card_11_text` varchar(20) NOT NULL,
  `card_12_text` varchar(20) NOT NULL,
  `card_13_text` varchar(20) NOT NULL,
  `card_14_text` varchar(20) NOT NULL,
  `card_15_text` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `color_picker`
INSERT INTO `color_picker` (`id`, `left_ber_bg`, `left_ber_text`, `top_ber_bg`, `top_ber_text`, `card_1_bg`, `card_2_bg`, `card_3_bg`, `card_4_bg`, `card_5_bg`, `card_6_bg`, `card_7_bg`, `card_8_bg`, `card_9_bg`, `card_10_bg`, `card_11_bg`, `card_12_bg`, `card_13_bg`, `card_14_bg`, `card_15_bg`, `card_1_text`, `card_2_text`, `card_3_text`, `card_4_text`, `card_5_text`, `card_6_text`, `card_7_text`, `card_8_text`, `card_9_text`, `card_10_text`, `card_11_text`, `card_12_text`, `card_13_text`, `card_14_text`, `card_15_text`) VALUES("1","#121526","#ffffff","#bc1edc","#ebebeb","#4182c8","#0ee1d3","#27dd2a","#2df054","#21e4cd","#1aea7f","#17ee90","#3bce89","#0ff0b8","#31e3ad","#0edd83","#1feac2","#1fc778","#0ddc09","#2aaecf","#ededed","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#e00000","#000000","#000000","#000000");


-- Table structure for table `computer_office_application`
DROP TABLE IF EXISTS `computer_office_application`;
CREATE TABLE `computer_office_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `mcq` int(11) NOT NULL,
  `viva` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `computer_office_application`
INSERT INTO `computer_office_application` (`id`, `std_id`, `mcq`, `viva`, `status`) VALUES("1","1","90","80","0");
INSERT INTO `computer_office_application` (`id`, `std_id`, `mcq`, `viva`, `status`) VALUES("2","0","0","0","0");


-- Table structure for table `course`
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course` varchar(255) DEFAULT NULL,
  `course_n_bangla` varchar(255) DEFAULT NULL,
  `c_amount` int(5) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `course_code` int(11) DEFAULT NULL,
  `minimum_payment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `course`
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("1","Play","প্লে ","5000","প্লে শ্রেণী","0","201","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("2","Nursery","নার্সারী ","6000","নার্সারী শ্রেণী","0","202","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("3","One","প্রথম ","9000","প্রথম শ্রেণী","0","203","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("4","Two","দ্বিতীয়","4000","দ্বিতীয় শ্রেণী","0","204","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("5","Three","তৃতীয় ","5000","তৃতীয় শ্রেণী","0","205","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("6","Four","চতুর্থ ","6000","চতুর্থ শ্রেণীর","0","206","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("7","Five","পঞ্চম","7000","পঞ্চম শ্রেণীর","0","207","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("8","Six","ষষ্ঠ","12000","ষষ্ঠ শ্রেণীর","0","208","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("9","Seven","সপ্তম","9000","সপ্তম শ্রেণি","0","209","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("10","Eight","অষ্টম","100000","অষ্টম শ্রেণি","0","210","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("11","Nine (General)","নবম (সাধারণ)","11000","নবম শ্রেণি","0","211","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("12","Ten (General)","দশম (সাধারণ)","12000","দশম শ্রেণি ","0","212","");


-- Table structure for table `course_subject`
DROP TABLE IF EXISTS `course_subject`;
CREATE TABLE `course_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(11) DEFAULT NULL,
  `religion` varchar(200) DEFAULT NULL,
  `subject_name` varchar(255) DEFAULT NULL,
  `subject_name_bn` varchar(250) DEFAULT NULL,
  `subject_code` varchar(20) DEFAULT NULL,
  `subject_code_bn` varchar(250) DEFAULT NULL,
  `group_id` varchar(30) DEFAULT NULL,
  `picture` varchar(100) DEFAULT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `written` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `4th_subject` varchar(200) DEFAULT NULL,
  `two_in_one` varchar(200) DEFAULT NULL,
  `two_in_one_2` varchar(200) DEFAULT NULL,
  `viva` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `total` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `priority` varchar(255) DEFAULT NULL,
  `two_in_one_3` varchar(255) DEFAULT NULL,
  `two_in_one_4` varchar(255) DEFAULT NULL,
  `two_in_one_5` varchar(255) DEFAULT NULL,
  `two_in_one_6` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `course_subject`
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("15","13",NULL,"Bangla","বাংলা","101","১০১","",NULL,"1","","","","","","",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("17","3","","English","ইংলিশ","102","১০২","Science",NULL,"1","","0","101","","","","2","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("18","3","","Mathematics","অংক","103","১০৩","",NULL,"1",NULL,"0","","",NULL,NULL,"3","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("19","3",NULL,"environment society and science","পরিবেশ সমাজ এবং বিজ্ঞান","104","১০৪","",NULL,"1",NULL,"0","","",NULL,NULL,"4","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("20","3","","physical education","শারীরিক শিক্ষা","105","১০৫","Science",NULL,"1",NULL,"0","","21",NULL,NULL,"5","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("21","3","","Arts and Crafts","চারু ও কারুশিল্প","106","১০৬","",NULL,"1",NULL,"0","","20",NULL,NULL,"6","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("22","3","Islam","Islam and moral education","ইসলাম ও নৈতিক শিক্ষা","107","১০৭","",NULL,"1",NULL,"0","","",NULL,NULL,"7","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("23","3","Hindu","Hinduism and moral education","হিন্দু ধর্ম ও নৈতিক শিক্ষা","108","১০৮","",NULL,"1",NULL,"0","","",NULL,NULL,"8","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("29","13",NULL,"বাংলা","n/a","3103","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("32","13",NULL,"ইসলামের ইতিহাস","n/a","3106","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("33","13",NULL,"সাধারণ জ্ঞান","n/a","3107","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("40","13",NULL,"Quaran","কোরআন","11111"," ১১১১১","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("41","13",NULL,"Quaran","কোরআন","111111"," ১১১১১","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("42","13",NULL,"Quaran 5","কোরআন 5","11111 5"," ১১১১১5","",NULL,"1","","","","","","",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("44","3","","Bangla","বাংলা","101","১০১","",NULL,"1",NULL,"0","102","",NULL,NULL,"1","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("45","5",NULL,"Bangla","বাংলা","3101","৩১০১","",NULL,"1",NULL,"0","","",NULL,NULL,"1","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("46","5","","English","ইংলিশ","3102","৩১০২","",NULL,"1",NULL,"0","","",NULL,NULL,"2","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("47","5",NULL,"Mathematics","গনিত","3103","৩১০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"3","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("48","5",NULL,"science","বিজ্ঞান","3104","৩১০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"4","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("49","5",NULL,"Islam","ইসলাম","3105","৩১০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"5","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("51","1",NULL,"Bangla","বাংলা","101","১০১","5",NULL,"1","","","","","","",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("52","1","","English","ইংলিশ","102","১০২","",NULL,"1","","1","101","","","","2","","","","");
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`) VALUES("53","1",NULL,"environment society and science","পরিবেশ সমাজ এবং বিজ্ঞান","104","১০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"4","","","","");


-- Table structure for table `custom_sms`
DROP TABLE IF EXISTS `custom_sms`;
CREATE TABLE `custom_sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `status` varchar(250) NOT NULL DEFAULT '1',
  `sms` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `custom_sms`
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("2","teacher","1","এখানে কাষ্টম এসএমএস লিখতে পারবেন");
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("3","student","0","Dear  `student_name` ,\nCongratulations! Your admission to ILMUL OHI MODEL MADRASHA has been successfully completed.  Your ID:  `student_id`");
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("4","user","0","এখানে কাষ্টম এসএমএস লিখতে পারবে");


-- Table structure for table `daily_study_v3`
DROP TABLE IF EXISTS `daily_study_v3`;
CREATE TABLE `daily_study_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course` int(11) NOT NULL,
  `branch` int(11) NOT NULL,
  `course_subject` int(11) NOT NULL,
  `date` date NOT NULL,
  `topic` varchar(300) NOT NULL,
  `details` text NOT NULL,
  `type` varchar(200) NOT NULL,
  `attachment` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `daily_study_v3`
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("1","3","1","18","2025-01-02","fdxgbfcx","gcxfbvcbn111111111111111111111","Home Work","4679862551download.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("8","3","5","21","2025-01-02","xzv","xvxcv","","Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("9","3","5","21","2025-01-02","xzv","xvxcv","","168666445Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("10","3","1","23","2025-01-02","fdxgbfcx","dxfdf","","479888102Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("11","3","1","23","2025-01-02","fdxgbfcx","dxfdf","","1134187533Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("12","3","1","23","2025-01-02","fdxgbfcx","fdsf","","");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("13","3","5","22","2025-01-02","sdaasda","dasd","","1418517119Screenshot_2.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("16","3","7","21","2025-01-02","fdxgbfcx","cxfgh","Class Test","1838744830_20_frd_1690101871.jpg");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("17","3","7","21","2025-01-02","fdxgbfcx","cxfgh","Home Work","1090605998_20_frd_1690101871.jpg");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("18","3","1","17","2025-01-07","fdxgbfcx","hhh","Home Work","14264393391download.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("19","3","1","17","2025-01-11","টেস্ট করার জন্য","বই -৩১ পিষ্টা","Class Test","185822426088.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("20","3","1","44","2025-04-04","function con($query) {     global $con;     return mysqli_query($con, $query); }  function row($query) {     return mysqli_fetch_assoc($query); }","function con($query)
\n{
\n    global $con;
\n    return mysqli_query($con, $query);
\n}
\n
\nfunction row($query)
\n{
\n    return mysqli_fetch_assoc($query);
\n}
\n","Home Work","342010631LMC_20250331_140847_COLOUR BOOST x GCAMTHEBOSS jpeg .jpg");


-- Table structure for table `description_list`
DROP TABLE IF EXISTS `description_list`;
CREATE TABLE `description_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description_name` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `des_fee` varchar(11) DEFAULT NULL,
  `payment_limited` varchar(11) DEFAULT NULL COMMENT '0= Unlomite, 1=Limite',
  `course_id` varchar(11) DEFAULT NULL,
  `course_year` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `description_list`
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("14","Admission Fee","0","","200","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("15","Session Fee","0","","300","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("16","Stationary/Certificate/TC","0","","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("17","Dress/hijab/cap","0","","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("18","Exam Fee",NULL,"","300","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("19","Monthly Fee",NULL,"","10","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("20","Edu.epuipment",NULL,"","300","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("22","Admit Card Fee",NULL,"12","20","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("23","Admission Fee",NULL,"","200","0","1","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("30","Course & Tuition Fees",NULL,"102","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("31","tttt",NULL,"","300","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("32","Admission Fee",NULL,"","300","0","4","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("34","ভর্তি ফি",NULL,"","200","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("35","সেশন ফি",NULL,"","300","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("36","মাসিক বেতন",NULL,"","500","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("37","প্রথম সাময়িক পরীক্ষার ফি",NULL,"","300","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("38","প্রবেশ ফি",NULL,"","150","","5","2025");


-- Table structure for table `device_connect`
DROP TABLE IF EXISTS `device_connect`;
CREATE TABLE `device_connect` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `person_name` varchar(250) DEFAULT NULL,
  `gender` varchar(250) DEFAULT NULL,
  `contact` varchar(250) DEFAULT NULL,
  `person_id` int(20) DEFAULT NULL,
  `person_type` varchar(100) DEFAULT NULL,
  `card_no` varchar(250) DEFAULT NULL,
  `uni_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `device_connect`
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("70","Md Aminur Rahman","1","01","170","student","","3");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("71","Md Ashraful Islam","1","01","169","student","","2");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("72","Md Rofiqul Islam","1","01","173","student","","6");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("73","Md Shagor Islam","1","01","174","student","","7");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("74","Mst Amina Begum","1","01","172","student","","5");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("75","Mst Janatul Mina","1","01","171","student","0013855409","4");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("77","Mst Amina Begum","1","01","172","student","5240485","5");


-- Table structure for table `discount`
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) DEFAULT NULL,
  `description_id` int(20) NOT NULL,
  `percent` varchar(100) DEFAULT NULL,
  `amount` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `discount`


-- Table structure for table `donar`
DROP TABLE IF EXISTS `donar`;
CREATE TABLE `donar` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `duration` varchar(100) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `donar`
INSERT INTO `donar` (`id`, `name`, `mobile`, `duration`, `address`, `add_date`, `update_date`) VALUES("4","জিয়ারুল ইসলাম ভাই-পিরগঞ্জ","01717452764","0","রংপুর","2023-11-15","2024-01-22");


-- Table structure for table `exam_publish_date`
DROP TABLE IF EXISTS `exam_publish_date`;
CREATE TABLE `exam_publish_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(100) DEFAULT NULL,
  `exam_year` varchar(100) DEFAULT NULL,
  `publish_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `exam_name` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `exam_publish_date`


-- Table structure for table `exam_result_v3`
DROP TABLE IF EXISTS `exam_result_v3`;
CREATE TABLE `exam_result_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(11) DEFAULT NULL,
  `course` varchar(200) DEFAULT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `year` varchar(200) DEFAULT NULL,
  `exam_id` varchar(200) DEFAULT NULL,
  `cq` varchar(200) DEFAULT NULL,
  `mcq` varchar(200) DEFAULT NULL,
  `practical` varchar(200) DEFAULT NULL,
  `oral` varchar(20) DEFAULT NULL,
  `total` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `regi_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `exam_result_v3`
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("200","1349","3","17","2024","10","20","5","15","15","55","2025-03-23 10:06:28",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("201","1357","3","17","2024","10","25","45","15","10","95","2025-03-23 10:06:28",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("202","1349","3","18","2024","10","50","0","0",NULL,"60","2025-03-23 10:06:36",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("203","1357","3","18","2024","10","86","0","0",NULL,"96","2025-03-23 10:06:36",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("204","1349","3","19","2024","10","90","0","0",NULL,"92","2025-03-23 10:06:43",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("205","1357","3","19","2024","10","85","0","0",NULL,"87","2025-03-23 10:06:43",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("206","1349","3","20","2024","10","50","40","0",NULL,"100","2025-03-23 10:06:54",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("207","1357","3","21","2024","10","50","40","0",NULL,"90","2025-03-23 10:07:05",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("208","1349","3","22","2024","10","90","0","0",NULL,"90","2025-03-23 10:07:14",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("209","1357","3","23","2024","10","80","5","2",NULL,"97","2025-03-23 10:07:20",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("210","1349","3","44","2024","10","60","20","0",NULL,"80","2025-03-23 10:07:34",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("211","1357","3","44","2024","10","65","18","0",NULL,"83","2025-03-23 10:07:34",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("212","1350","1","53","2024","10","60","20","0",NULL,"80","2025-03-27 00:44:25",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("213","1350","1","52","2024","10","60","20","0",NULL,"80","2025-03-27 00:44:28",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("214","1350","1","51","2024","10","60","20","0",NULL,"80","2025-03-27 00:44:31",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("215","1349","3","19","2024","11","90","0","0",NULL,"92","2025-03-29 11:24:00",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("216","1357","3","19","2024","11","85","0","0",NULL,"87","2025-03-29 11:24:00",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("217","1349","3","17","2024","11","90","15","0","0","105","2025-03-29 11:24:07",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("218","1357","3","17","2024","11","85","10","0","0","95","2025-03-29 11:24:07",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("219","1349","3","18","2024","11","90","0","0",NULL,"92","2025-03-29 11:24:10",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("220","1357","3","18","2024","11","85","0","0",NULL,"87","2025-03-29 11:24:10",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("221","1349","3","44","2024","11","20","20","20",NULL,"60","2025-03-29 11:24:28",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("222","1357","3","44","2024","11","20","20","20",NULL,"60","2025-03-29 11:24:28",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("223","1357","3","23","2024","11","50","30","0",NULL,"80","2025-03-29 11:24:38",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("224","1349","3","22","2024","11","60","20","0",NULL,"80","2025-03-29 11:24:45",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("225","1349","3","20","2024","11","60","30","0",NULL,"90","2025-03-29 11:24:53",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("226","1357","3","21","2024","11","50","20","10",NULL,"80","2025-03-29 11:25:07",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("228","1349","3","17","2024","13","20","0","0","0","20","2025-03-29 11:48:22","2031");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("229","1357","3","17","2024","13","12","12","0","0","24","2025-03-29 11:48:22",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("230","1349","3","18","2024","13","60","0","0","0","60","2025-03-29 11:48:30","2031");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("231","1357","3","18","2024","13","12","112","0","0","124","2025-03-29 11:48:30",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("232","1349","3","19","2024","13","80","0","0","0","80","2025-03-29 11:48:36",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("233","1357","3","19","2024","13","20","20","20","0","60","2025-03-29 11:48:36",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("234","1349","3","20","2024","13","80","0","0","0","80","2025-03-29 11:48:41",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("235","1357","3","21","2024","13","20","20","20","0","60","2025-03-29 11:48:47",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("236","1349","3","22","2024","13","80","0","0","0","80","2025-03-29 11:48:52",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("237","1357","3","23","2024","13","20","20","20","0","60","2025-03-29 11:48:58",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("238","1349","3","44","2024","13","80","0","0","0","80","2025-03-29 11:49:05",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("239","1357","3","44","2024","13","20","20","20","0","60","2025-03-29 11:49:05",NULL);
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("240","1349","3","17","2024","12","20","20","0","0","40","2025-03-29 21:34:37","2031");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`) VALUES("241","1349","3","18","2024","12","40","40","20","0","100","2025-03-29 21:34:55","2031");


-- Table structure for table `exam_v3`
DROP TABLE IF EXISTS `exam_v3`;
CREATE TABLE `exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `exam_name` varchar(500) DEFAULT NULL,
  `priority` varchar(11) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish_time` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `exam_v3`
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("10","2024","Modal Test-1","1","2024-12-06","05:38","2024-12-11 11:15:26");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("11","2024","Modal Test-3","3","2024-12-05","","2024-12-11 09:13:35");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("12","2024","Modal Test-2","2","0000-00-00","","2024-12-11 11:15:33");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("13","2024","Modal Test-4","4","0000-00-00","","2024-12-11 09:13:26");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("14","2025","প্রথম সাময়িক পরীক্ষা","1","0000-00-00","","2024-12-25 07:37:50");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("15","2025","Add New Exam","1","2025-01-17","19:36","2025-01-17 08:41:59");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("16","2025","hgnvb","2","2025-01-11","11:36","2025-01-17 11:34:01");


-- Table structure for table `examination_name`
DROP TABLE IF EXISTS `examination_name`;
CREATE TABLE `examination_name` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `exam_name` varchar(200) DEFAULT NULL,
  `exam_center_name` varchar(255) DEFAULT NULL,
  `exam_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `examination_name`
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("21","1st Examination-2024","ইকরা দারুল কুরআন মাদরাসা কালীগঞ্জ","first");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("23","Second Temporary Exam","ইকরা দারুল কুরআন মাদরাসা কালীগঞ্জ","secend");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("24","Third Term Exam","ইকরা দারুল কুরআন মাদরাসা কালীগঞ্জ","last_exam_l");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("25","M.T Marks-Half Yearly Examination","half_yearly_mt","half_yearly_mt");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("26","H. Yearly Marks-Half Yearly Examination","half_yearly_h","half_yearly_h");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("27","M.T Marks-Yearly Examination","yearly_mt","yearly_mt");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("28","Yearly Marks-Yearly Examination","yearly_mark","yearly_mark");
INSERT INTO `examination_name` (`id`, `exam_name`, `exam_center_name`, `exam_key`) VALUES("29","Annual Examination","ইকরা দারুল কুরআন মাদরাসা কালীগঞ্জ","third");


-- Table structure for table `expense`
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `expense_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_amount` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `expense_details` varchar(250) NOT NULL,
  `expense_receipt` varchar(250) NOT NULL,
  `expense_date` varchar(255) NOT NULL,
  `expense_month` varchar(250) NOT NULL,
  `expense_year` varchar(250) NOT NULL,
  PRIMARY KEY (`expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `expense`
INSERT INTO `expense` (`expense_id`, `expense_amount`, `category_id`, `expense_details`, `expense_receipt`, `expense_date`, `expense_month`, `expense_year`) VALUES("8","100","1","","","2022-11-08","01","2023");
INSERT INTO `expense` (`expense_id`, `expense_amount`, `category_id`, `expense_details`, `expense_receipt`, `expense_date`, `expense_month`, `expense_year`) VALUES("9","6000","1","","","2023-05-11","05","2023");


-- Table structure for table `fees_transaction`
DROP TABLE IF EXISTS `fees_transaction`;
CREATE TABLE `fees_transaction` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `stdid` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `paid` int(255) NOT NULL,
  `discount` int(255) NOT NULL,
  `submitdate` datetime NOT NULL,
  `receiver` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `transcation_remark` text CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `fees_transaction`


-- Table structure for table `grad_point_v3`
DROP TABLE IF EXISTS `grad_point_v3`;
CREATE TABLE `grad_point_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `points_grades` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `grad_point_v3`
INSERT INTO `grad_point_v3` (`id`, `name`, `points_grades`, `date`) VALUES("3","GPA Calculator1","[{\"point\":\"4.00\",\"grad\":\"A+\"},{\"point\":\"3.75\",\"grad\":\"A\"},{\"point\":\"3.50\",\"grad\":\"A-\"},{\"point\":\"3.25\",\"grad\":\"B+\"},{\"point\":\"3.00\",\"grad\":\"B\"},{\"point\":\"2.75\",\"grad\":\"B-\"},{\"point\":\"2.50\",\"grad\":\"C+\"},{\"point\":\"2.00\",\"grad\":\"C\"},{\"point\":\"1.75\",\"grad\":\"D\"},{\"point\":\"0.00\",\"grad\":\"F\"}]","2025-01-11 09:58:17");
INSERT INTO `grad_point_v3` (`id`, `name`, `points_grades`, `date`) VALUES("8","GPA Calculator2","[{\"point\":\"5.00\",\"grad\":\"A+\"},{\"point\":\"4.00\",\"grad\":\"A\"},{\"point\":\"3.50\",\"grad\":\"A-\"},{\"point\":\"3.00\",\"grad\":\"B\"},{\"point\":\"2.00\",\"grad\":\"C\"},{\"point\":\"1.00\",\"grad\":\"D\"},{\"point\":\"0.00\",\"grad\":\"F\"}]","2025-01-11 10:05:37");


-- Table structure for table `grading_v3`
DROP TABLE IF EXISTS `grading_v3`;
CREATE TABLE `grading_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `class_id` varchar(11) DEFAULT NULL,
  `subject_id` varchar(11) DEFAULT NULL,
  `exam_id` varchar(11) DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `max_mark` varchar(50) DEFAULT NULL,
  `pass_mark` varchar(200) DEFAULT NULL,
  `class_id_hidden` varchar(500) DEFAULT NULL,
  `cq_pass_mark` int(11) DEFAULT NULL,
  `mcq_pass_mark` int(11) DEFAULT NULL,
  `practical_pass_mark` int(11) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `grading_v3`
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("6","2024","3","23","3","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4}]","100","","",NULL,NULL,NULL,"","2024-11-05 20:56:21");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("13","2025","3","23","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4}]","100","","",NULL,NULL,NULL,"","2024-11-11 15:13:12");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("14","2026","3","23","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4}]","100","","",NULL,NULL,NULL,"","2024-11-11 15:13:15");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("16","2024","3","22","7","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"}]","80","","",NULL,NULL,NULL,"","2024-11-05 20:58:39");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("17","2024","211","32","7","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","100","","11",NULL,NULL,NULL,"","2024-11-10 22:41:46");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("19","2024","203","17","7","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"}]","100","","",NULL,NULL,NULL,"","2024-11-07 02:10:52");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("33","2024","211","33","7","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","100","","11",NULL,NULL,NULL,"","2024-11-11 15:23:01");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("34","2024","211","42","7","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","100","","11",NULL,NULL,NULL,"","2024-11-13 11:28:17");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("35","2024","211","42","4","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","100","","11",NULL,NULL,NULL,"","2024-11-11 15:13:20");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("36","2024","211","33","4","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","100","","11",NULL,NULL,NULL,"","2024-11-11 15:13:23");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("37","2024","211","32","4","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":50,\"grade\":\"B\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":3}]","150","","11",NULL,NULL,NULL,"","2024-11-14 11:25:28");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("39","2024","211","45","10","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"69\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"59\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:42:28");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("40","2024","211","46","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:42:53");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("41","2024","211","47","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:43:08");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("42","2024","211","48","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:43:31");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("43","2024","211","49","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:43:46");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("44","2024","211","50","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:44:07");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("45","2024","211","51","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:44:21");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("46","2024","211","52","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:48:20");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("47","2024","211","53","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":69,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","","11",NULL,NULL,NULL,"","2024-11-21 09:48:34");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("57","2024","3","17","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0","","2024-11-30 14:24:25");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("60","2024","3","17","0","[]","","","3",NULL,NULL,NULL,"","2024-11-30 08:21:33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("61","2024","3","17","0","[]","","","3",NULL,NULL,NULL,"","2024-11-30 08:21:44");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("62","2024","3","17","0","[]","","","3",NULL,NULL,NULL,"","2024-11-30 08:23:07");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("75","2024","3","18","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0","","2024-12-11 10:50:37");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("76","2024","3","19","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:51:01");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("77","2024","3","20","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:51:23");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("78","2024","3","21","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:51:39");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("79","2024","3","22","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:52:02");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("80","2024","3","23","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:52:20");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("81","2024","3","44","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,NULL,NULL,"","2024-12-11 10:52:34");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("113","2025","3","17","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","20","15","6",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("114","2025","3","18","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","20","10","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("115","2025","3","19","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("116","2025","3","20","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("117","2025","3","21","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("118","2025","3","22","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("119","2025","3","23","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("120","2025","3","44","14","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","30","0","0",NULL,"2025-01-23 17:39:54");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("121","2024","3","17","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","25","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("122","2024","3","18","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("123","2024","3","19","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("124","2024","3","20","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("125","2024","3","21","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("126","2024","3","22","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("127","2024","3","23","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("128","2024","3","44","12","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-01-24 20:55:16");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("129","2024","1","51","10","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"80\",\"min\":\"60\",\"grade\":\"A\",\"point\":\"4.00\"}]","100","33","1","33","0","0",NULL,"2025-03-27 00:45:49");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("130","2024","1","52","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":60,\"grade\":\"A\",\"point\":4}]","100","33","1","33","0","0",NULL,"2025-03-27 00:45:56");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("131","2024","1","53","10","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":60,\"grade\":\"A\",\"point\":4}]","100","33","1","33","0","0",NULL,"2025-03-27 00:45:58");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("133","2024","3","17","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("134","2024","3","18","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("135","2024","3","19","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("136","2024","3","20","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("137","2024","3","21","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("138","2024","3","22","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("139","2024","3","23","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("140","2024","3","44","11","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 11:49:40");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("141","2024","3","17","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("142","2024","3","18","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("143","2024","3","19","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("144","2024","3","20","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("145","2024","3","21","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("146","2024","3","22","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("147","2024","3","23","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `status`, `date`) VALUES("148","2024","3","44","13","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":70,\"grade\":\"A\",\"point\":4.5},{\"max\":70,\"min\":60,\"grade\":\"B\",\"point\":4},{\"max\":60,\"min\":45,\"grade\":\"C\",\"point\":3},{\"max\":44,\"min\":33,\"grade\":\"D\",\"point\":2},{\"max\":33,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3","0","0","0",NULL,"2025-03-29 21:28:41");


-- Table structure for table `height_mark`
DROP TABLE IF EXISTS `height_mark`;
CREATE TABLE `height_mark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(255) NOT NULL,
  `mark_year` varchar(100) NOT NULL,
  `class_id` int(11) NOT NULL,
  `mark_number` float NOT NULL,
  `subject_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `created_add` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `height_mark`


-- Table structure for table `holiday_v3`
DROP TABLE IF EXISTS `holiday_v3`;
CREATE TABLE `holiday_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `date` date NOT NULL,
  `add_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `holiday_v3`
INSERT INTO `holiday_v3` (`id`, `name`, `date`, `add_time`) VALUES("4","বিজয় দিবস","2024-12-25","2024-12-27 15:30:17");


-- Table structure for table `in_bank_invoice`
DROP TABLE IF EXISTS `in_bank_invoice`;
CREATE TABLE `in_bank_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) NOT NULL,
  `billing_type` varchar(100) NOT NULL,
  `ac_no` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) NOT NULL,
  `total_amount` int(20) DEFAULT 0,
  `discount` int(20) DEFAULT 0,
  `due` int(20) DEFAULT 0,
  `paid_amount` int(20) DEFAULT 0,
  `billing_time` varchar(100) NOT NULL,
  `add_date` varchar(100) NOT NULL,
  `update_date` varchar(100) NOT NULL,
  `add_author` longtext NOT NULL,
  `update_author` longtext NOT NULL,
  `check_update` int(20) DEFAULT 0,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `in_bank_invoice`


-- Table structure for table `in_bank_list`
DROP TABLE IF EXISTS `in_bank_list`;
CREATE TABLE `in_bank_list` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(200) NOT NULL,
  `bank_account` varchar(200) NOT NULL,
  `holder_name` varchar(100) NOT NULL,
  `bank_mobile` varchar(250) DEFAULT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `in_bank_list`


-- Table structure for table `income`
DROP TABLE IF EXISTS `income`;
CREATE TABLE `income` (
  `income_id` int(11) NOT NULL AUTO_INCREMENT,
  `income_amount` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `income_details` varchar(250) NOT NULL,
  `income_receipt` varchar(250) NOT NULL,
  `income_date` varchar(255) NOT NULL,
  `income_month` varchar(255) NOT NULL,
  `income_year` varchar(255) NOT NULL,
  PRIMARY KEY (`income_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `income`
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("3","200","5","","","2022-01-29","01","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("4","500","6","","","2022-01-31","01","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("5","500","3","uku","","2022-11-08","11","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("9","90","3","","8e06a13c506c7d4d3ef7343b9a9dee2a.jpg","2022-12-02","12","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("11","900","3","","","2023-05-11","05","2023");


-- Table structure for table `information`
DROP TABLE IF EXISTS `information`;
CREATE TABLE `information` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `person_id` varchar(250) DEFAULT NULL,
  `date_time` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `time` varchar(250) DEFAULT NULL,
  `direction` varchar(250) DEFAULT NULL,
  `type` varchar(250) DEFAULT NULL,
  `serial_no` varchar(250) DEFAULT NULL,
  `person_name` varchar(250) DEFAULT NULL,
  `card_no` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=538 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `information`
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("496","17","2024-02-13T17:12:50","2024-02-13","17:12:50","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("497","18","2024-02-13T17:13:14","2024-02-13","17:13:14","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("498","18","2024-02-13T17:13:28","2024-02-13","17:13:28","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("499","18","2024-02-13T17:13:41","2024-02-13","17:13:41","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("500","17","2024-02-13T17:13:43","2024-02-13","17:13:43","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("501","17","2024-02-13T17:13:44","2024-02-13","17:13:44","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("502","17","2024-02-13T17:15:10","2024-02-13","17:15:10","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("503","17","2024-02-13T17:16:03","2024-02-13","17:16:03","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("504","18","2024-02-13T17:25:25","2024-02-13","17:25:25","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("505","17","2024-02-13T17:25:26","2024-02-13","17:25:26","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("506","18","2024-02-13T17:25:28","2024-02-13","17:25:28","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("507","18","2024-02-13T17:25:36","2024-02-13","17:25:36","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("508","17","2024-02-13T17:25:39","2024-02-13","17:25:39","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("509","18","2024-02-13T17:25:43","2024-02-13","17:25:43","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("510","17","2024-02-13T17:25:45","2024-02-13","17:25:45","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("511","18","2024-02-13T17:25:47","2024-02-13","17:25:47","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("512","17","2024-02-13T17:25:52","2024-02-13","17:25:52","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("513","18","2024-02-13T17:25:54","2024-02-13","17:25:54","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("516","18","2024-02-13T17:29:09","2024-02-13","17:29:09","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("517","18","2024-02-13T17:29:24","2024-02-13","17:29:24","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("518","18","2024-02-13T17:29:31","2024-02-13","17:29:31","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("519","17","2024-02-13T17:29:36","2024-02-13","17:29:36","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("520","18","2024-02-13T17:30:01","2024-02-13","17:30:01","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("522","18","2024-02-13T17:45:44","2024-02-13","17:45:44","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("523","18","2024-02-13T17:45:50","2024-02-13","17:45:50","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("524","18","2024-02-13T17:45:52","2024-02-13","17:45:52","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("525","18","2024-02-13T17:45:56","2024-02-13","17:45:56","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("526","17","2024-02-13T17:46:01","2024-02-13","17:46:01","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("527","17","2024-02-13T17:46:03","2024-02-13","17:46:03","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("529","18","2024-02-13T19:12:37","2024-02-13","19:12:37","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("531","17","2024-02-13T19:13:47","2024-02-13","19:13:47","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("532","18","2024-02-13T19:13:57","2024-02-13","19:13:57","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("534","18","2024-02-13T19:35:43","2024-02-13","19:35:43","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("535","17","2024-02-13T19:35:55","2024-02-13","19:35:55","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("536","18","2024-02-13T19:36:08","2024-02-13","19:36:08","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("537","18","2024-02-13T19:36:21","2024-02-13","19:36:21","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");


-- Table structure for table `institution_name_ex`
DROP TABLE IF EXISTS `institution_name_ex`;
CREATE TABLE `institution_name_ex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name_bangla` varchar(255) DEFAULT NULL,
  `name_english` varchar(255) DEFAULT NULL,
  `name_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `institution_name_ex`
INSERT INTO `institution_name_ex` (`id`, `name_bangla`, `name_english`, `name_code`) VALUES("1","নাই","N/A",NULL);


-- Table structure for table `jh_payment`
DROP TABLE IF EXISTS `jh_payment`;
CREATE TABLE `jh_payment` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `student_id` varchar(20) NOT NULL,
  `course_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `payment_date` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `total_payment` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `due` int(11) NOT NULL,
  `accept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `accept_id` int(11) DEFAULT NULL,
  `status` int(2) NOT NULL COMMENT '1 = complite_payment\r\n2 = incomplite_payment',
  `description_name` varchar(255) NOT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `jh_payment`
INSERT INTO `jh_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("96","1698198532_592102591","1","0","50","2023-10-25","","8950","admin","1","0","5",NULL,NULL,"2023-10-25 07:48:52");
INSERT INTO `jh_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("97","1699073197_1689803675","1","0","500","2023-11-04","","8450","admin","1","0","3",NULL,NULL,"2023-11-04 10:46:37");


-- Table structure for table `language_table`
DROP TABLE IF EXISTS `language_table`;
CREATE TABLE `language_table` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `lang` varchar(100) NOT NULL DEFAULT 'en',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `language_table`
INSERT INTO `language_table` (`id`, `lang`) VALUES("1","en");


-- Table structure for table `last_id_history`
DROP TABLE IF EXISTS `last_id_history`;
CREATE TABLE `last_id_history` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `last_id` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `last_id_history`
INSERT INTO `last_id_history` (`id`, `last_id`) VALUES("1","955");


-- Table structure for table `leave_application_v3`
DROP TABLE IF EXISTS `leave_application_v3`;
CREATE TABLE `leave_application_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi_id` int(11) NOT NULL,
  `class_teacher` varchar(200) DEFAULT NULL,
  `application_type` varchar(200) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `application_date` datetime NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message` text NOT NULL,
  `approve_by` varchar(200) DEFAULT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'Pending',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `leave_application_v3`


-- Table structure for table `login_otp`
DROP TABLE IF EXISTS `login_otp`;
CREATE TABLE `login_otp` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sending_method` varchar(100) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `custom_sms` varchar(250) DEFAULT NULL,
  `type` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `login_otp`
INSERT INTO `login_otp` (`id`, `sending_method`, `status`, `custom_sms`, `type`) VALUES("1","mobile","off","WebBazarBD YOUR LOG IN OTP","admin");
INSERT INTO `login_otp` (`id`, `sending_method`, `status`, `custom_sms`, `type`) VALUES("2","mobile","off","User Login OTP","user");


-- Table structure for table `logo`
DROP TABLE IF EXISTS `logo`;
CREATE TABLE `logo` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `names` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `logo`


-- Table structure for table `mark_condition`
DROP TABLE IF EXISTS `mark_condition`;
CREATE TABLE `mark_condition` (
  `mark_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(255) NOT NULL,
  `subject_code` varchar(50) NOT NULL,
  `total_subject_mark` varchar(50) NOT NULL,
  `mark_condition` text NOT NULL,
  `exam_year` varchar(100) NOT NULL,
  `time_code` varchar(100) NOT NULL,
  `exam_name` varchar(100) NOT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`mark_id`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `mark_condition`


-- Table structure for table `marksheet`
DROP TABLE IF EXISTS `marksheet`;
CREATE TABLE `marksheet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `theoretical` int(11) NOT NULL,
  `report` int(11) NOT NULL,
  `practical` int(11) NOT NULL,
  `verbal` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `marksheet`
INSERT INTO `marksheet` (`id`, `std_id`, `theoretical`, `report`, `practical`, `verbal`, `status`) VALUES("1","1","60","160","20","20","0");
INSERT INTO `marksheet` (`id`, `std_id`, `theoretical`, `report`, `practical`, `verbal`, `status`) VALUES("2","100","60","160","20","20","0");
INSERT INTO `marksheet` (`id`, `std_id`, `theoretical`, `report`, `practical`, `verbal`, `status`) VALUES("3","2","60","160","20","20","0");


-- Table structure for table `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `migrations`


-- Table structure for table `mode_test_exam_v3`
DROP TABLE IF EXISTS `mode_test_exam_v3`;
CREATE TABLE `mode_test_exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(500) DEFAULT NULL,
  `course` varchar(200) DEFAULT NULL,
  `year` varchar(500) DEFAULT NULL,
  `json_data` text DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `mode_test_exam_v3`
INSERT INTO `mode_test_exam_v3` (`id`, `exam`, `course`, `year`, `json_data`, `status`, `date`) VALUES("19","M-1","One","2024","{\"course\":\"One\",\"subjects\":[\"English\",\"Mathematics\",\"environment society and science\"],\"year\":\"2024\",\"exam\":\"M-1\",\"total_mark\":\"100\",\"marks_data\":[{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"marks\":[{\"subject\":\"English\",\"mark\":\"99\"},{\"subject\":\"Mathematics\",\"mark\":\"80\"},{\"subject\":\"environment society and science\",\"mark\":\"90\"}]},{\"student_id\":\"2031\",\"student_name\":\"Al Imran\",\"marks\":[{\"subject\":\"English\",\"mark\":\"50\"},{\"subject\":\"Mathematics\",\"mark\":\"50\"},{\"subject\":\"environment society and science\",\"mark\":\"50\"}]}]}",NULL,"2024-12-23 09:10:55");


-- Table structure for table `new_sms_permission`
DROP TABLE IF EXISTS `new_sms_permission`;
CREATE TABLE `new_sms_permission` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `active_provider` varchar(200) NOT NULL,
  `admission_status` varchar(200) DEFAULT NULL,
  `status` int(20) NOT NULL DEFAULT 0,
  `mram_api_key` varchar(255) DEFAULT NULL,
  `mram_sender_id` varchar(255) DEFAULT NULL,
  `mram_secret_key` varchar(255) DEFAULT NULL,
  `smsq_api_key` varchar(255) DEFAULT NULL,
  `smsq_sender_id` varchar(255) DEFAULT NULL,
  `smsq_secret_key` varchar(255) DEFAULT NULL,
  `greenweb_api_key` varchar(255) DEFAULT NULL,
  `greenweb_sender_id` varchar(255) DEFAULT NULL,
  `greenweb_secret_key` varchar(255) DEFAULT NULL,
  `webbazarbd_api_key` varchar(255) DEFAULT NULL,
  `webbazarbd_sender_id` varchar(255) DEFAULT NULL,
  `webbazarbd_secret_key` varchar(255) DEFAULT NULL,
  `bulksmsbd_api_key` varchar(255) DEFAULT NULL,
  `bulksmsbd_sender_id` varchar(255) DEFAULT NULL,
  `bulksmsbd_secret_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `new_sms_permission`
INSERT INTO `new_sms_permission` (`id`, `active_provider`, `admission_status`, `status`, `mram_api_key`, `mram_sender_id`, `mram_secret_key`, `smsq_api_key`, `smsq_sender_id`, `smsq_secret_key`, `greenweb_api_key`, `greenweb_sender_id`, `greenweb_secret_key`, `webbazarbd_api_key`, `webbazarbd_sender_id`, `webbazarbd_secret_key`, `bulksmsbd_api_key`, `bulksmsbd_sender_id`, `bulksmsbd_secret_key`) VALUES("1","webbazarbd","1","1","C3001559668e8ae9767c06.10893131","8809601014316","1","3K2dYM6wnjuEQxiIo0soBBU6zoK3HhDQDnK+111FsKU=","8809617614922","9e74079e-5013-4c27-a802-584e14740822","c8eaf3b218fd1abf6d9c9ffa31d3481c","0","0","CPGeYE1ZgIvWPJj1716874237","6638120995","1","1AoFy64Ecuj2XP9SB8J2","8809617624936","1");


-- Table structure for table `new_user_table`
DROP TABLE IF EXISTS `new_user_table`;
CREATE TABLE `new_user_table` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `username` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `password` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `create_date` varchar(250) DEFAULT NULL,
  `auth` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `new_user_table`
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("8","Fuzlul","user1","webbazarbd24@gmail.com","01713728112","123456","1","1698791982","teacher");
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("9","abdul","user2","webbazarbd242@gmail.com","01717452764","123456","1","1698900236","student");
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("10","Sub-Admin","subadmin","webbazarbd20@gmail.com","01717452764","123456","1","1700649936","all-control");
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("11","TestUser1","testuser111","abcd@gmail.com","01717002452","627174","1","1717905734","all-control");
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("13","Dhaka-Chittagong","dhakachittagong13","mdibrahimbashar1@gmail.com","01713728112","301927","1","1743738227","Resultcontrol & Student");


-- Table structure for table `notification_add_student`
DROP TABLE IF EXISTS `notification_add_student`;
CREATE TABLE `notification_add_student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi` int(11) NOT NULL,
  `sname` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `image` varchar(255) NOT NULL,
  `ad_noti` varchar(500) NOT NULL,
  `time_stamp` int(11) NOT NULL,
  `edite_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_date` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `notification_add_student`
INSERT INTO `notification_add_student` (`id`, `regi`, `sname`, `image`, `ad_noti`, `time_stamp`, `edite_time`, `last_date`) VALUES("15","1","mst amin beguum","","    hi","1669292757","2022-11-24 18:34:13","2022-11-30");


-- Table structure for table `online_admission_switch`
DROP TABLE IF EXISTS `online_admission_switch`;
CREATE TABLE `online_admission_switch` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `online_admission_switch`
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("1","online-admission","on");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("2","admission-fee","10");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("3","max-time","24");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("4","payment-method","SSL");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("5","youtube","https://www.youtube.com/embed/mWZ6b_I-Djg");


-- Table structure for table `online_notice`
DROP TABLE IF EXISTS `online_notice`;
CREATE TABLE `online_notice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `notice` longtext NOT NULL,
  `notice_id` varchar(250) NOT NULL,
  `status` int(5) NOT NULL DEFAULT 1,
  `expire_time` varchar(250) NOT NULL,
  `publish_date` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `online_notice`
INSERT INTO `online_notice` (`id`, `title`, `notice`, `notice_id`, `status`, `expire_time`, `publish_date`) VALUES("4","আগামীকাল সফটওয়্যার বন্ধ থাকবে","আগামীকাল সফটওয়্যার বন্ধ থাকবে","10","1","1732201422","1732190622");


-- Table structure for table `operator_description`
DROP TABLE IF EXISTS `operator_description`;
CREATE TABLE `operator_description` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `op_description` varchar(200) NOT NULL,
  `oprator_image` varchar(100) DEFAULT NULL,
  `oprator_key` varchar(100) NOT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`op_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `operator_description`
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("3","bkash",NULL,"bkash","payment_operator");
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("4","Monthly payment",NULL,"monthly_payment","payment_description");
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("9","Cash",NULL,"cash","payment_operator");


-- Table structure for table `p_customer`
DROP TABLE IF EXISTS `p_customer`;
CREATE TABLE `p_customer` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `categories_id` int(20) DEFAULT NULL,
  `mobile` varchar(100) NOT NULL,
  `duration` varchar(100) DEFAULT NULL,
  `address` varchar(150) NOT NULL,
  `add_date` varchar(100) NOT NULL,
  `update_date` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p_customer`


-- Table structure for table `p_customer_categories`
DROP TABLE IF EXISTS `p_customer_categories`;
CREATE TABLE `p_customer_categories` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p_customer_categories`


-- Table structure for table `p_invoice`
DROP TABLE IF EXISTS `p_invoice`;
CREATE TABLE `p_invoice` (
  `p_in_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) NOT NULL,
  `customer_name` varchar(150) NOT NULL,
  `customer_mobile` varchar(50) NOT NULL,
  `customer_address` varchar(250) NOT NULL,
  `product_information` longtext NOT NULL,
  `files` varchar(100) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `total_amount` int(20) DEFAULT NULL,
  `discount` int(20) DEFAULT NULL,
  `due` int(20) DEFAULT NULL,
  `paid_amount` int(20) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `create_date` varchar(100) NOT NULL,
  `d_status` int(10) DEFAULT 1,
  PRIMARY KEY (`p_in_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p_invoice`


-- Table structure for table `p_invoice_temp`
DROP TABLE IF EXISTS `p_invoice_temp`;
CREATE TABLE `p_invoice_temp` (
  `temp_in_id` int(20) NOT NULL AUTO_INCREMENT,
  `in_id` int(20) NOT NULL,
  `temp_mobile` varchar(100) NOT NULL,
  `temp_amount` int(20) NOT NULL,
  `temp_date` varchar(100) NOT NULL,
  `temp_dates` varchar(250) NOT NULL,
  `d_status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`temp_in_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p_invoice_temp`


-- Table structure for table `p_product`
DROP TABLE IF EXISTS `p_product`;
CREATE TABLE `p_product` (
  `p_id` int(20) NOT NULL AUTO_INCREMENT,
  `p_name` varchar(250) NOT NULL,
  `p_amount` int(20) NOT NULL,
  `p_add_date` varchar(100) DEFAULT NULL,
  `p_update_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p_product`
INSERT INTO `p_product` (`p_id`, `p_name`, `p_amount`, `p_add_date`, `p_update_date`) VALUES("1","SM PDF APPS","1000","2023-12-15","2023-12-15");
INSERT INTO `p_product` (`p_id`, `p_name`, `p_amount`, `p_add_date`, `p_update_date`) VALUES("2","SMS SOFT APP","2000","2023-12-15","2023-12-15");


-- Table structure for table `password_resets`
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `password_resets`


-- Table structure for table `payment_redirect`
DROP TABLE IF EXISTS `payment_redirect`;
CREATE TABLE `payment_redirect` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `link_name` varchar(250) DEFAULT NULL,
  `status` int(20) NOT NULL,
  `note` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `payment_redirect`
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("1","bangla","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("2","english","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("3","english2","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("4","pos_english","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("5","pos_bangla","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("6","invoice-6","1","Please make the payment by the due date to avoid any late fees. For assistance, contact the finance department and reference your student ID");


-- Table structure for table `payment_three`
DROP TABLE IF EXISTS `payment_three`;
CREATE TABLE `payment_three` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `student_id` int(20) NOT NULL,
  `course_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `payment_date` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `total_payment` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `due` int(11) NOT NULL,
  `accept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `accept_id` int(11) DEFAULT NULL,
  `status` int(2) NOT NULL COMMENT '1 = complite_payment\r\n2 = incomplite_payment',
  `description_name` varchar(255) NOT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `payment_three`
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("87","1674528266","3","0","10","24-01-2023","","7800","admin","1","0","3",NULL,NULL,"2023-01-24 08:44:26");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("88","1674529240","3","0","30","24-01-2023","","7780","admin","1","0","4",NULL,NULL,"2023-01-24 09:00:40");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("89","1674529504","2","0","50","24-01-2023","","8950","admin","1","0","5",NULL,NULL,"2023-01-24 09:05:04");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("90","1674533549","3","0","50","24-01-2023","","0","admin","1","0","6",NULL,NULL,"2023-01-24 10:12:29");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("91","1674785062","3","0","30","27-01-2023","","0","admin","1","0","4",NULL,NULL,"2023-01-27 08:04:22");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("92","1674785189","1","0","30","27-01-2023","","0","admin","1","0","5",NULL,NULL,"2023-01-27 08:06:29");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("93","1674880514","3","0","30","28-01-2023","","0","admin","1","0","5",NULL,NULL,"2023-01-28 10:35:14");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("94","1674880591","1","0","30","28-01-2023","","0","admin","1","0","5",NULL,NULL,"2023-01-28 10:36:31");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("95","1674880651","1","0","30","28-01-2023","","0","admin","1","0","5",NULL,NULL,"2023-01-28 10:37:31");
INSERT INTO `payment_three` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("96","1674880850","1","0","50","28-01-2023","","0","admin","1","0","4",NULL,NULL,"2023-01-28 10:40:50");


-- Table structure for table `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `module` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `permissions`
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("76","Student","Dashboard","2025-04-03 11:28:47");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("77","Student Seat Plane","Dashboard","2025-04-03 11:29:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("78","Routine All","Dashboard","2025-04-03 11:29:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("79","Attendance","Dashboard","2025-04-03 11:30:03");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("80","Examination","Dashboard","2025-04-03 11:30:16");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("81","Registration","Dashboard","2025-04-03 11:30:32");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("82","Card Information","Dashboard","2025-04-03 11:30:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("83","Card Expiry","Dashboard","2025-04-03 11:30:54");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("84","Testimonial","Dashboard","2025-04-03 11:31:04");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("85","Basic Certificate","Dashboard","2025-04-03 11:31:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("86","Class,Group,Session,Section,Shift","Dashboard","2025-04-03 11:31:26");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("87","Institution Name","Dashboard","2025-04-03 11:31:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("88","Teacher Panel","Dashboard","2025-04-03 11:31:47");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("89","SMS Panel","Dashboard","2025-04-03 11:31:57");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("90","Note Notification","Dashboard","2025-04-03 11:32:09");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("91","Staff Entry","Dashboard","2025-04-03 11:32:34");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("92","Notice","Dashboard","2025-04-03 11:32:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("93","Promotion","Dashboard","2025-04-03 11:32:46");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("94","Visitor Portal","Dashboard","2025-04-03 11:32:54");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("95","Backup","Dashboard","2025-04-03 11:33:04");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("96","Subjects,Mark,Grading,eSif","Resultcontrol","2025-04-03 11:47:11");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("97","Certificate Manage","Resultcontrol","2025-04-03 11:47:35");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("98","MarkSheet","Resultcontrol","2025-04-03 11:47:46");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("99","TabilationSheet","Resultcontrol","2025-04-03 11:48:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("100","Student List,DCR,Blank Mark Input","Resultcontrol","2025-04-03 11:48:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("101","Progressive Report","Resultcontrol","2025-04-03 11:49:00");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("102","Result SMS","Resultcontrol","2025-04-03 11:49:15");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("103","Result Settings","Resultcontrol","2025-04-03 11:49:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("104","Role Management","Dashboard","2025-04-04 08:37:31");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("105","Resultcontrol Panel","Dashboard","2025-04-04 09:50:43");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("106","Activity Panel","Dashboard","2025-04-04 09:51:09");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("107","Accounting Panel","Dashboard","2025-04-04 09:51:21");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("108","Study Management","Activity","2025-04-04 09:53:48");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("109","Activity Management","Activity","2025-04-04 09:54:08");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("110","Holidays Management","Activity","2025-04-04 09:54:23");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("111","TC Management","Activity","2025-04-04 09:54:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("112","Applications Management","Activity","2025-04-04 09:54:56");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("113","Activity Settings","Activity","2025-04-04 09:55:11");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("114","Collection & Report & Due","Accounting","2025-04-04 10:02:39");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("115","Costs & Incomes","Accounting","2025-04-04 10:03:00");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("116","Student Dues Report","Accounting","2025-04-04 10:03:21");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("117","Due SMS System","Accounting","2025-04-04 10:03:53");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("118","Ledger","Accounting","2025-04-04 10:04:29");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("119","Setup","Accounting","2025-04-04 10:04:40");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("121","Payment Requests","Accounting","2025-04-04 10:05:13");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("122","SSL Payment","Accounting","2025-04-04 10:05:23");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("123","Manage bKash","Accounting","2025-04-04 10:05:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("124","Accounting Settings","Accounting","2025-04-04 10:05:57");


-- Table structure for table `person_categories`
DROP TABLE IF EXISTS `person_categories`;
CREATE TABLE `person_categories` (
  `cat_id` int(20) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(250) NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `person_categories`


-- Table structure for table `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `personal_access_tokens`


-- Table structure for table `print_template`
DROP TABLE IF EXISTS `print_template`;
CREATE TABLE `print_template` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `image` varchar(200) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `template_no` int(10) NOT NULL,
  `card_no` varchar(255) DEFAULT NULL,
  `bottom_page` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `print_template`
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("1","template/template_1707213818_From_For_HQIS_06-02-2024[1].png","1","1","1-School_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("2","template/template_1707699923_From_d_BN-2.png","0","2","2-School_Bangla",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("3","template/template_1711596292_3.from-d-3-School_English.png","0","3","3-School_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("4","template/template_1723073889_4.from-d-4-Coaching_English.png","0","4","4-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("5","template/template_1717496840_5.From_d-5-Madrsha_Bangla.png","0","5","5-Madrsha_Bangla",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("6","template/template_1733987956_6.From-d-6-Coaching_English.png","0","6","6-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("7","template/template_1711598186_7.from-d-7-Coaching_English.png","0","7","7-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("8","template/template_1723348327_8.from-d-8-Coaching_English.png","0","8","8-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("9","template/template_1731939036_08 ADMISSION  new Form-images-0.jpg","0","9","9-JAMIA ISLAMIA DARUL","template/template_1731939043_08 ADMISSION  new Form-images-1.jpg");
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("10","template/template_1733642272_10.From-d-10-Madrsha_Bangla.png","0","10","10-Madrsha_Bangla",NULL);


-- Table structure for table `quota_student`
DROP TABLE IF EXISTS `quota_student`;
CREATE TABLE `quota_student` (
  `quota_stu_id` int(11) NOT NULL AUTO_INCREMENT,
  `quota_ba` varchar(255) NOT NULL,
  `quota_en` varchar(255) NOT NULL,
  PRIMARY KEY (`quota_stu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `quota_student`
INSERT INTO `quota_student` (`quota_stu_id`, `quota_ba`, `quota_en`) VALUES("2","নাই","N/A");


-- Table structure for table `regination_settings`
DROP TABLE IF EXISTS `regination_settings`;
CREATE TABLE `regination_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sig1_name` varchar(5000) DEFAULT NULL,
  `sig2_name` varchar(500) DEFAULT NULL,
  `note1` text DEFAULT NULL,
  `note2` text DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `regination_settings`
INSERT INTO `regination_settings` (`id`, `sig1_name`, `sig2_name`, `note1`, `note2`, `issue_date`) VALUES("1","Signature of the Student	","Signature of Head of the Institute","This Registration card is Valid for six months.","For all communications with the insititute code, registation number and session are be mentioned.","2025-03-12");


-- Table structure for table `role_permissions`
DROP TABLE IF EXISTS `role_permissions`;
CREATE TABLE `role_permissions` (
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`permission_id`),
  KEY `permission_id` (`permission_id`),
  CONSTRAINT `role_permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_permissions_ibfk_2` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `role_permissions`
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","76");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","77");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","78");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","79");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","80");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","81");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","82");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","83");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","84");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","85");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","86");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","87");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","88");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","89");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","90");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","91");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","92");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","93");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","94");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","95");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","96");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","97");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","98");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","99");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","100");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","101");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","102");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","103");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","104");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","105");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","106");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","107");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","108");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","109");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","110");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","111");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","112");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","113");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","114");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","115");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","116");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","117");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","118");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","119");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","121");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","122");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","123");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","124");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","76");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","77");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","78");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","96");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","97");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","98");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","99");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","101");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","105");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","106");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","108");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","109");


-- Table structure for table `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `roles`
INSERT INTO `roles` (`id`, `name`, `description`, `created_at`) VALUES("5","admin","","2025-04-03 09:21:49");
INSERT INTO `roles` (`id`, `name`, `description`, `created_at`) VALUES("7","Resultcontrol & Student","","2025-04-04 08:51:39");


-- Table structure for table `room`
DROP TABLE IF EXISTS `room`;
CREATE TABLE `room` (
  `room_id` int(11) NOT NULL AUTO_INCREMENT,
  `room_name` varchar(255) NOT NULL,
  PRIMARY KEY (`room_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `room`
INSERT INTO `room` (`room_id`, `room_name`) VALUES("1","101");
INSERT INTO `room` (`room_id`, `room_name`) VALUES("2","107");
INSERT INTO `room` (`room_id`, `room_name`) VALUES("11","100");


-- Table structure for table `save_routine_v3`
DROP TABLE IF EXISTS `save_routine_v3`;
CREATE TABLE `save_routine_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `section` varchar(100) DEFAULT NULL,
  `year` varchar(100) DEFAULT NULL,
  `exam_id` varchar(100) DEFAULT NULL,
  `branch` varchar(100) DEFAULT NULL,
  `academic_year` varchar(100) DEFAULT NULL,
  `routine_details` text DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `save_routine_v3`
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `status`, `date`) VALUES("3","211","Morning","A","2024","7","General","2024-2025","{\"subject_id\":\"Quaran 5\",\"date\":\"2024-11-08\",\"start_time\":\"13:25\",\"end_time\":\"13:25\"}","","2024-11-12 11:23:37");
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `status`, `date`) VALUES("4","211","Morning","A","2024","4","General","2024-2025","[{\"subject_id\":\"\\u0987\\u09b8\\u09b2\\u09be\\u09ae\\u09c7\\u09b0 \\u0987\\u09a4\\u09bf\\u09b9\\u09be\\u09b8\",\"date\":\"2024-11-13\",\"start_time\":\"11:31\",\"end_time\":\"11:32\"},{\"subject_id\":\"\\u09b8\\u09be\\u09a7\\u09be\\u09b0\\u09a3 \\u099c\\u09cd\\u099e\\u09be\\u09a8\",\"date\":\"2024-11-17\",\"start_time\":\"11:33\",\"end_time\":\"11:31\"},{\"subject_id\":\"Quaran 5\",\"date\":\"2024-11-15\",\"start_time\":\"11:32\",\"end_time\":\"11:30\"}]","","2024-11-12 11:29:46");


-- Table structure for table `semester_exam_v3`
DROP TABLE IF EXISTS `semester_exam_v3`;
CREATE TABLE `semester_exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `class` varchar(200) DEFAULT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `mt` varchar(200) DEFAULT NULL,
  `semester` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `semester_exam_v3`
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("2","2024","3","19","65","55","2024-11-30 08:23:36");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("4","2024","3","17","30","50","2024-11-30 08:30:52");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("5","2024","3","18","50","25","2024-11-30 08:31:04");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("7","2024","3","20","50","25","2024-12-02 09:51:56");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("8","2024","3","21","100","33","2024-12-02 09:52:10");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("9","2024","3","22","100","50","2024-12-02 09:52:23");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("10","2024","3","23","100","90","2024-12-02 09:52:34");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("12","2024","3","44","70","30","2024-12-02 10:05:46");


-- Table structure for table `sessions`
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payload` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `sessions`
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES("1","0","::1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36","YTozOntzOjY6Il90b2tlbiI7czo0MDoiU2l4emFiWDA5NjFValNDb1ZUNHZ0RVlndnlSRTBydDdiS3hTMmloWCI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NTI6Imh0dHA6Ly9sb2NhbGhvc3Qvc3R1ZGVudF9tYW5hZ21lbnRfc3lzdGVtL3Ntcy9wdWJsaWMiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19","1625916890");


-- Table structure for table `set_grade_system_v3`
DROP TABLE IF EXISTS `set_grade_system_v3`;
CREATE TABLE `set_grade_system_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(500) NOT NULL,
  `grade_id` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `set_grade_system_v3`
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("1","marksheet_1","8","2025-01-11 10:06:01");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("2","marksheet_2","8","2025-01-11 10:06:06");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("4","marksheet_4","8","2025-01-11 10:06:08");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("6","marksheet_6","8","2025-01-11 10:06:10");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("7","marksheet_7","8","2025-01-11 10:06:12");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("10","merit_list_1","8","2025-01-11 10:06:13");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("11","merit_list_2","8","2025-01-11 10:06:15");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("12","certificate_english","8","2025-01-11 10:06:17");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("13","certificate_bangla","8","2025-01-11 10:06:20");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("14","certification_letter_en","8","2025-01-11 10:06:24");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("15","certification_letter","8","2025-01-11 10:06:49");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("16","progressive_report_1","8","2025-01-11 10:06:45");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("17","progressive_report_2","8","2025-01-11 10:06:41");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("18","progressive_report_3","8","2025-01-11 10:06:36");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("19","progressive_report_4","8","2025-01-11 10:06:33");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("21","marksheet_3","8","2025-01-11 10:06:06");


-- Table structure for table `settings_certificate_v3`
DROP TABLE IF EXISTS `settings_certificate_v3`;
CREATE TABLE `settings_certificate_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_english` varchar(2000) NOT NULL,
  `certificate_bangla` varchar(2000) NOT NULL,
  `certificate_letter_english` varchar(2000) NOT NULL,
  `certificate_letter_bangla` varchar(2000) NOT NULL,
  `signature_1` varchar(200) NOT NULL,
  `signature_2` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `certificate_english_head` varchar(200) NOT NULL,
  `certificate_bangla_head` varchar(200) NOT NULL,
  `certificate_letter_english_head` varchar(200) NOT NULL,
  `certificate_letter_bangla_head` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `settings_certificate_v3`
INSERT INTO `settings_certificate_v3` (`id`, `certificate_english`, `certificate_bangla`, `certificate_letter_english`, `certificate_letter_bangla`, `signature_1`, `signature_2`, `date`, `certificate_english_head`, `certificate_bangla_head`, `certificate_letter_english_head`, `certificate_letter_bangla_head`) VALUES("1","This is to certify that `student_name`, daughter of `fname`,  student of `website_name` , `address` , bearing Student ID `student_regi_no`, Roll No. `roll` and studying Class `course_name` , `Failed_or_Passed` the `exam_name`  of `year` in `branch` Group and obtained a G.P.A of `gpa` in the scale of 5.00.","এই মর্মে সার্টিফিকেট প্রদান করা যাচ্ছে যে `student_name`, পিতা `fname`, `website_name_bn`, `address_bn` এর ছাত্রী, যার ছাত্র আইডি `student_reg_no`,  রোল নম্বর `roll_2` এবং শ্রেণী `course_name` এ অধ্যয়নরত `Failed_or_Passed` হয়েছে `exam_name` পরীক্ষায় `year` সালে `branch` গ্রুপে এবং ৫.০০ এর স্কেলে একটি জি.পি.এ `gpa` অর্জন করেছে।","He/She has been a regular student of this institution in the year `year`, in the class `course_name`, and has passed with a GPA of `gpa` He/She is eligible for promotion to the next class. This certificate is issued upon the request of the guardian.","সে এই প্রতিষ্ঠানে একজন নিয়মিত শিক্ষার্থী হিসেবে `year` সালে,  `course_name` শ্রেণিতে , জিপিএ `gpa` পেয়ে উত্তীর্ণ হয়েছে। সে পরবর্তী শ্রেণিতে উন্নীত হওয়ার যোগ্য। তার অভিভাবকের আবেদনের প্রেক্ষিতে প্রত্যয়নপত্র প্রদান করা হল।","পরীক্ষা আহ্বায়ক1","অধ্যক্ষ (ভারপ্রাপ্ত)1","2025-02-02 20:36:08","Certificate1","সার্টিফিকেট1","Certification Letter1","প্রত্যয়ন পত্র1");


-- Table structure for table `settings_v3`
DROP TABLE IF EXISTS `settings_v3`;
CREATE TABLE `settings_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `website_name` varchar(250) NOT NULL,
  `short_name` varchar(100) NOT NULL,
  `website_name_bn` varchar(500) NOT NULL,
  `email` varchar(250) NOT NULL,
  `phone` varchar(250) NOT NULL,
  `logo` varchar(500) NOT NULL,
  `watermark` varchar(500) NOT NULL,
  `result_system` varchar(200) NOT NULL,
  `address` varchar(500) NOT NULL,
  `address_bn` varchar(200) NOT NULL,
  `site_url` varchar(200) NOT NULL,
  `col_1` varchar(200) NOT NULL,
  `col_3` varchar(200) NOT NULL,
  `col_2` varchar(200) NOT NULL,
  `col_4` varchar(200) DEFAULT NULL,
  `result_show` varchar(500) NOT NULL,
  `signature_1` varchar(200) NOT NULL,
  `signature_2` varchar(200) NOT NULL,
  `holidays` text NOT NULL,
  `grading_formula` text NOT NULL,
  `slogan` varchar(300) NOT NULL,
  `sms_content` varchar(1000) NOT NULL,
  `certificate_cover` varchar(200) NOT NULL,
  `hide_head` varchar(200) DEFAULT NULL,
  `backup_path` text DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `settings_v3`
INSERT INTO `settings_v3` (`id`, `website_name`, `short_name`, `website_name_bn`, `email`, `phone`, `logo`, `watermark`, `result_system`, `address`, `address_bn`, `site_url`, `col_1`, `col_3`, `col_2`, `col_4`, `result_show`, `signature_1`, `signature_2`, `holidays`, `grading_formula`, `slogan`, `sms_content`, `certificate_cover`, `hide_head`, `backup_path`, `date`) VALUES("1","ILMUL OHI MODEL MADRASHA","ILMUL"," ই\'লমুল ওহী মডেল মাদ্রাসা","ilmulohimodelmadrasha@gmail.com","01717731692","logo_1735624401_logo.png","watermark_1735624401_logo.png","esif","Jawlahati, Kamrangircor, Dhaka ","কামরাঙ্গীরচর, ঢাকা","http://localhost/webbazar_smartschool_v5","CQ","PR","MCQ","Final","mark_sheet_1","signature_1_1735149414_Screenshot_8.png","signature_2_1735149414_Screenshot_6.png","Friday,Saturday","grading_formula2","আপনার সন্তান গড়ে তোলার দায়িত্ব আমাদের","`exam_name`, `student_name_bn` , আইডি: `student_id_bn`, ক্লাস: `class_bn`, জিপিএ : `gpa_bn` পেয়েছো, Total Mark: `total_mark_bn`, Max Mark : `max_mark_bn`।, মেরিট পজিশন: `position_bn`।  `school_name`।","certificate_cover_1736073774_Untitled design.png","head_hide","stuImages,images, resultcontrol/images, students-image,activity/images,activity/students-image,card-section-v1/images,id-card-control/image,income_expense/all_reciept,income_expense/banner,teacher_registration_data/images,staff_data/images,admin_notic,","2025-03-29 12:04:51");


-- Table structure for table `share_holder`
DROP TABLE IF EXISTS `share_holder`;
CREATE TABLE `share_holder` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `details` longtext NOT NULL,
  `create_date` varchar(250) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `share_holder`


-- Table structure for table `shift_system`
DROP TABLE IF EXISTS `shift_system`;
CREATE TABLE `shift_system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_name_bn` varchar(200) NOT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `shift_system`
INSERT INTO `shift_system` (`id`, `shift_name`, `shift_name_bn`, `delete_status`) VALUES("3","Morning","সকাল","0");


-- Table structure for table `sms`
DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `status` int(10) NOT NULL DEFAULT 1,
  `type` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `sms`
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("1","1","teacher");
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("2","1","student");
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("3","0","user");


-- Table structure for table `sms_api_v3`
DROP TABLE IF EXISTS `sms_api_v3`;
CREATE TABLE `sms_api_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `apiUrl` varchar(1000) NOT NULL,
  `apiKey` varchar(1000) NOT NULL,
  `authKey` varchar(1000) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `result_link` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `sms_api_v3`
INSERT INTO `sms_api_v3` (`id`, `apiUrl`, `apiKey`, `authKey`, `date`, `result_link`) VALUES("1","https://api-sms.webbazarbd.com//sms-v2-api.php","CPGeYE1ZgIvWPJj1716874237","6638120995","2025-02-11 19:11:00","http://localhost/webbazar_amarschoolpro_v4/");


-- Table structure for table `sms_config`
DROP TABLE IF EXISTS `sms_config`;
CREATE TABLE `sms_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `status` int(10) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `sms_config`


-- Table structure for table `sms_deactive`
DROP TABLE IF EXISTS `sms_deactive`;
CREATE TABLE `sms_deactive` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `sms_deactive`
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("1","teacher","0");
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("2","student","1");
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("3","staff","0");


-- Table structure for table `sms_log_v3`
DROP TABLE IF EXISTS `sms_log_v3`;
CREATE TABLE `sms_log_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `placeholders` text NOT NULL,
  `status` varchar(500) NOT NULL DEFAULT 'active',
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `sms_log_v3`
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("2","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:12:31");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("3","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:19:25");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("4","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:20:49");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("5","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:22:58");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("6","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:24:35");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("7","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:25:51");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("8","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"\",\"student_name_en\":\"Al Imran\",\"`student_id_bn`\":\"২\",\"`student_id_en`\":\"2\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"২\",\"position_en\":2,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 15:25:51");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("9","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 18:20:46");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("10","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 18:22:09");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("11","{\"`exam_name`\":\"Modal Test1\",\"`student_name_bn`\":\"asd\",\"student_name_en\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"১\",\"`student_id_en`\":\"1\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.২৫\",\"`gpa_en`\":4.25,\"`position_bn`\":\"১\",\"position_en\":1,\"`school_name`\":\"Shamsul Haque Model Madrasa\"}","active","2024-11-24 18:22:48");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("12","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.১৪\",\"`gpa_en`\":4.14,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:11:10");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("13","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.১৪\",\"`gpa_en`\":4.14,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:12:35");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("14","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.১৪\",\"`gpa_en`\":4.14,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:14:03");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("15","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.১৪\",\"`gpa_en`\":4.14,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:15:07");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("16","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.১৪\",\"`gpa_en`\":4.14,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:20:43");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("17","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 19:21:49");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("18","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 20:12:19");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("19","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 20:13:20");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("20","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 20:13:40");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("21","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-11 20:14:28");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("22","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-16 18:32:37");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("23","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আবরার আফহাতী\",\"`student_name_en`\":\"Al Imran\",\"`student_id_bn`\":\"২০৩১\",\"`student_id_en`\":\"2031\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৮\",\"`gpa_en`\":4.88,\"`total_mark`\":632,\"`total_mark_bn`\":\"৬৩২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-16 20:34:25");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("24","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"২\",\"`position_en`\":2,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-02-16 20:34:25");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("25","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আবরার আফহাতী\",\"`student_name_en`\":\"Al Imran\",\"`student_id_bn`\":\"২০৩১\",\"`student_id_en`\":\"2031\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৮\",\"`gpa_en`\":4.88,\"`total_mark`\":632,\"`total_mark_bn`\":\"৬৩২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"১\",\"`position_en`\":1,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-03-19 11:44:20");
INSERT INTO `sms_log_v3` (`id`, `placeholders`, `status`, `date`) VALUES("26","{\"`exam_name`\":\"Modal Test-1\",\"`student_name_bn`\":\"মো: আশরাফুল ইসলাম \",\"`student_name_en`\":\"MD ABRAR AFTAHI\",\"`student_id_bn`\":\"২০৩২\",\"`student_id_en`\":\"2032\",\"`class_bn`\":\"প্রথম \",\"`class_en`\":\"One\",\"`gpa_bn`\":\"৪.৮৬\",\"`gpa_en`\":4.86,\"`total_mark`\":612,\"`total_mark_bn`\":\"৬১২\",\"`max_mark`\":\"709\",\"`max_mark_bn`\":\"৭০৯\",\"`position_bn`\":\"২\",\"`position_en`\":2,\"`school_name`\":\"ILMUL OHI MODEL MADRASHA\"}","active","2025-03-19 11:44:20");


-- Table structure for table `st_postion`
DROP TABLE IF EXISTS `st_postion`;
CREATE TABLE `st_postion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ps_year` varchar(100) DEFAULT NULL,
  `ps_class` varchar(255) DEFAULT NULL,
  `ps_exam` varchar(255) DEFAULT NULL,
  `ps_std_id` varchar(100) DEFAULT NULL,
  `ps_mark` float DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `st_postion`


-- Table structure for table `staff_data`
DROP TABLE IF EXISTS `staff_data`;
CREATE TABLE `staff_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `name_bn` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL COMMENT '1=active, 0=false',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `stup_image` varchar(100) DEFAULT NULL,
  `qr_code_generator` varchar(100) DEFAULT NULL,
  `staff_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `blood_group` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `expire_date` varchar(255) DEFAULT NULL,
  `joined_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `staff_data`
INSERT INTO `staff_data` (`id`, `name`, `name_bn`, `position`, `mobile`, `email_address`, `status`, `created_at`, `stup_image`, `qr_code_generator`, `staff_id`, `blood_group`, `expire_date`, `joined_date`) VALUES("11","Md Fozlul Hoque","মো: ফজলুল হক","Supervisor","01717452764","webbazarbd24@gmail.com","0","2024-02-22 09:48:21","images/1698197169.jpg","staff_11","S_250","A+","2024-10-23","2023-10-23");
INSERT INTO `staff_data` (`id`, `name`, `name_bn`, `position`, `mobile`, `email_address`, `status`, `created_at`, `stup_image`, `qr_code_generator`, `staff_id`, `blood_group`, `expire_date`, `joined_date`) VALUES("13","Md Fozlul Hoque","মো: ফজলুল হক","Computer Op","01717452764","abcd@gmail.com",NULL,"2024-10-04 07:00:04","images/1720138095.png","staff_1385348","2024990","A+","2024-12-31","2024-01-01");


-- Table structure for table `staff_id_card_template`
DROP TABLE IF EXISTS `staff_id_card_template`;
CREATE TABLE `staff_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(12) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `staff_id_card_template`
INSERT INTO `staff_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1704922036_staff_id_card_1.png","1","1","0","0","0");
INSERT INTO `staff_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1704922170_staff_id_card_2.png","2","1","0","0","0");
INSERT INTO `staff_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1707196826_staff_id_card_3.png","3","1","0","0","0");
INSERT INTO `staff_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1710476590_staff_id_card_4.png","4","1","0","0","0");
INSERT INTO `staff_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("5","image/template_1720246875_staff_id_card_5.png","5","1","0","0","1");


-- Table structure for table `staff_time`
DROP TABLE IF EXISTS `staff_time`;
CREATE TABLE `staff_time` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(250) NOT NULL,
  `start_from` varchar(250) NOT NULL,
  `start_to` varchar(250) NOT NULL,
  `late_start` varchar(250) NOT NULL,
  `late_end` varchar(250) NOT NULL,
  `end_form` varchar(250) NOT NULL,
  `end_to` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `staff_time`


-- Table structure for table `std_registation`
DROP TABLE IF EXISTS `std_registation`;
CREATE TABLE `std_registation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_name_b` varchar(255) NOT NULL,
  `std_name_e` varchar(255) NOT NULL,
  `f_name_b` varchar(255) NOT NULL,
  `f_name_e` varchar(255) NOT NULL,
  `m_name_b` varchar(255) NOT NULL,
  `m_name_e` varchar(255) NOT NULL,
  `guardian` varchar(255) NOT NULL,
  `p_villege` varchar(255) NOT NULL,
  `p_post_name` varchar(255) NOT NULL,
  `p_upzila` varchar(255) NOT NULL,
  `p_zila` varchar(255) NOT NULL,
  `p_mobile` varchar(255) NOT NULL,
  `per_address` varchar(255) NOT NULL,
  `guardian_mobile` varchar(255) NOT NULL,
  `birth_day` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `nationality` varchar(255) NOT NULL,
  `religion` varchar(255) NOT NULL,
  `course_duration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `course_session` varchar(255) NOT NULL,
  `course_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `jsc_role` varchar(255) NOT NULL,
  `jsc_subject` varchar(255) NOT NULL,
  `jsc_passing` varchar(255) NOT NULL,
  `jsc_gpa` varchar(255) NOT NULL,
  `jsc_board` varchar(255) NOT NULL,
  `ssc_roll` varchar(255) NOT NULL,
  `ssc_subject` varchar(255) NOT NULL,
  `ssc_passing_year` varchar(255) NOT NULL,
  `ssc_bivag` varchar(255) NOT NULL,
  `ssc_board` varchar(255) NOT NULL,
  `st_images` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '0 Panding, 1 Approved',
  `tmp_id` int(11) NOT NULL,
  `form_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `gender` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `course_price` int(11) NOT NULL,
  `guardian_year_income` varchar(255) NOT NULL,
  `st_guardian_profession` varchar(255) NOT NULL,
  `st_guardian_vill` varchar(255) NOT NULL,
  `st_guardian_post` varchar(255) NOT NULL,
  `st_union_name` varchar(255) NOT NULL,
  `st_guardian_upzi` varchar(255) NOT NULL,
  `st_guardian_dist` varchar(255) NOT NULL,
  `quota_student` varchar(255) NOT NULL,
  `institution_Name_b_ssc` varchar(255) NOT NULL,
  `institution_Name_e_ssc` varchar(255) NOT NULL,
  `institution_adr_ssc` varchar(255) NOT NULL,
  `roll_no_ssc` varchar(255) NOT NULL,
  `regi_no_ssc` varchar(255) NOT NULL,
  `pass_year_ssc` varchar(255) NOT NULL,
  `group_trade_ssc` varchar(255) NOT NULL,
  `gpa_ssc` varchar(255) NOT NULL,
  `board_ssc` varchar(255) NOT NULL,
  `institution_Name_b_hsc` varchar(255) NOT NULL,
  `institution_Name_e_hsc` varchar(255) NOT NULL,
  `institution_adr_hsc` varchar(255) NOT NULL,
  `roll_no_hsc` varchar(255) NOT NULL,
  `regi_no_hsc` varchar(255) NOT NULL,
  `pass_year_hsc` varchar(255) NOT NULL,
  `group_trade_hsc` varchar(255) NOT NULL,
  `gpa_hsc` varchar(255) NOT NULL,
  `board_hsc` varchar(255) NOT NULL,
  `f_birth_day` varchar(255) NOT NULL,
  `m_birth_day` varchar(255) NOT NULL,
  `st_national_bir_id` varchar(255) NOT NULL,
  `f_national_bir_id` varchar(255) NOT NULL,
  `m_national_bir_id` varchar(255) NOT NULL,
  `per_union_name` varchar(255) NOT NULL,
  `academic_year` varchar(255) NOT NULL,
  `blood_group_st` varchar(255) NOT NULL,
  `board_shotcord` varchar(255) NOT NULL,
  `class_section_name` varchar(255) NOT NULL,
  `academic_year_name_bn` varchar(255) NOT NULL,
  `shift_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `std_registation`


-- Table structure for table `stu_attendance`
DROP TABLE IF EXISTS `stu_attendance`;
CREATE TABLE `stu_attendance` (
  `at_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `id` int(11) NOT NULL,
  `date` varchar(30) NOT NULL,
  PRIMARY KEY (`at_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `stu_attendance`
INSERT INTO `stu_attendance` (`at_id`, `value`, `id`, `date`) VALUES("15","Present","13","24-11-21");
INSERT INTO `stu_attendance` (`at_id`, `value`, `id`, `date`) VALUES("16","Absent","13","25-11-21");
INSERT INTO `stu_attendance` (`at_id`, `value`, `id`, `date`) VALUES("17","Absent","13","27-11-21");


-- Table structure for table `student`
DROP TABLE IF EXISTS `student`;
CREATE TABLE `student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registation_com_id` varchar(250) DEFAULT NULL,
  `regi` varchar(250) DEFAULT NULL,
  `emailid` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `sname` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `std_name_b` varchar(255) DEFAULT NULL,
  `fname` varchar(30) DEFAULT NULL,
  `f_name_b` varchar(255) DEFAULT NULL,
  `joindate` varchar(100) DEFAULT NULL,
  `about_v` varchar(255) DEFAULT NULL,
  `about_p` varchar(255) DEFAULT NULL,
  `about_t` varchar(255) DEFAULT NULL,
  `about_d` varchar(255) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `fees` varchar(11) DEFAULT NULL,
  `branch` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `s_year` varchar(50) DEFAULT NULL,
  `course` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` varchar(11) DEFAULT NULL,
  `delete_status` varchar(11) NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mName` varchar(255) DEFAULT NULL,
  `m_name_b` varchar(255) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `birth_day` varchar(255) DEFAULT NULL,
  `discount` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `tmp_id` varchar(250) DEFAULT NULL,
  `roll_2` varchar(250) DEFAULT NULL,
  `user_id` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `show_pass` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT '0' COMMENT '1=Active, 0=False',
  `st_union_name` varchar(255) DEFAULT NULL,
  `p_post_name` varchar(255) DEFAULT NULL,
  `guardian_year_income` varchar(255) DEFAULT NULL,
  `st_guardian_profession` varchar(255) DEFAULT NULL,
  `st_guardian_vill` varchar(255) DEFAULT NULL,
  `st_guardian_post` varchar(255) DEFAULT NULL,
  `st_guardian_upzi` varchar(255) DEFAULT NULL,
  `st_guardian_dist` varchar(255) DEFAULT NULL,
  `quota_student` varchar(255) DEFAULT NULL,
  `institution_Name_b_ssc` varchar(255) DEFAULT NULL,
  `institution_Name_e_ssc` varchar(255) DEFAULT NULL,
  `institution_adr_ssc` varchar(255) DEFAULT NULL,
  `roll_no_ssc` varchar(255) DEFAULT NULL,
  `regi_no_ssc` varchar(255) DEFAULT NULL,
  `pass_year_ssc` varchar(255) DEFAULT NULL,
  `group_trade_ssc` varchar(255) DEFAULT NULL,
  `gpa_ssc` varchar(255) DEFAULT NULL,
  `board_ssc` varchar(255) DEFAULT NULL,
  `institution_Name_b_hsc` varchar(255) DEFAULT NULL,
  `institution_Name_e_hsc` varchar(255) DEFAULT NULL,
  `institution_adr_hsc` varchar(255) DEFAULT NULL,
  `roll_no_hsc` varchar(255) DEFAULT NULL,
  `regi_no_hsc` varchar(255) DEFAULT NULL,
  `pass_year_hsc` varchar(255) DEFAULT NULL,
  `group_trade_hsc` varchar(255) DEFAULT NULL,
  `gpa_hsc` varchar(255) DEFAULT NULL,
  `board_hsc` varchar(255) DEFAULT NULL,
  `jsc` longtext DEFAULT NULL,
  `masters` longtext DEFAULT NULL,
  `f_birth_day` varchar(255) DEFAULT NULL,
  `m_birth_day` varchar(255) DEFAULT NULL,
  `st_national_bir_id` varchar(255) DEFAULT NULL,
  `f_national_bir_id` varchar(255) DEFAULT NULL,
  `m_national_bir_id` varchar(255) DEFAULT NULL,
  `per_union_name` varchar(255) DEFAULT NULL,
  `academic_year_name_bn` varchar(255) DEFAULT NULL,
  `blood_group_st` varchar(255) DEFAULT NULL,
  `board_shotcord` varchar(255) DEFAULT NULL,
  `class_section_name` varchar(255) DEFAULT NULL,
  `qr_code_generator` varchar(100) DEFAULT NULL,
  `shift_name` varchar(255) DEFAULT NULL,
  `permision` varchar(2) DEFAULT NULL,
  `be_tmp` varchar(11) DEFAULT NULL,
  `p_ad_v` varchar(255) DEFAULT NULL,
  `p_ad_t` varchar(255) DEFAULT NULL,
  `p_ad_p` varchar(255) DEFAULT NULL,
  `p_ad_d` varchar(255) DEFAULT NULL,
  `f_contact_number` varchar(100) DEFAULT NULL,
  `id_type` varchar(250) DEFAULT NULL,
  `expire_date` varchar(255) DEFAULT NULL,
  `joined_date` varchar(255) DEFAULT NULL,
  `status_approved` varchar(255) NOT NULL DEFAULT '0' COMMENT '0 Panding, 1 Approved',
  `trade_name` varchar(255) DEFAULT NULL,
  `s_mother_profession` varchar(255) DEFAULT NULL,
  `institution_name_ex` varchar(255) DEFAULT NULL,
  `present_school_name` varchar(255) DEFAULT NULL,
  `religion` varchar(255) DEFAULT NULL,
  `guardian_name` varchar(255) DEFAULT NULL,
  `relationship_parent` varchar(255) DEFAULT NULL,
  `parental_address` varchar(255) DEFAULT NULL,
  `guardian_mobile` varchar(255) DEFAULT NULL,
  `whatsapp_no` varchar(255) DEFAULT NULL,
  `medical_info` varchar(250) DEFAULT NULL,
  `previous_institute_name` varchar(255) DEFAULT NULL,
  `previous_institute_class` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1371 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `student`
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1349","020243","2031","webbazarbd24@gmail.com","Al Imran","মো: আবরার আফহাতী","YOUNOSH KHAN","","28-Jan-2025:07:36","Lalmonirhat","lalmonirhat","kaliganj","5520","01875996913","","1","2024","3","","0","1731944700.jpg","Most shohida begum","","male","2025-01-28","","1731587676","1","Al_3791349","d6a99d4bc68601cfc41346762dbc22d5","Al_1733376286","1","","","","","","","","",NULL,"","","","","","","","","","","none","","none","none","none","none","none","none","none","none","","","","","","","4","none","","6","","3","1","","","","","","0","Passport-No","","","1","","","","","Islam","মো: আরিফুল ইসলাম","ভাই","01717452764","01717452764","","","","");
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1350",NULL,"2011","webbazarbd24@gmail.com","aaa","","YOUNOSH KHAN",NULL,"18-11-2024:09:50 PM","Lalmonirhat","lalmonirhat","kaliganj","5520","01717452764","5000","1","2024","1",NULL,"0","1731945044.png","Most shohida begum",NULL,"female","2024-10-29","0","1731945044",NULL,NULL,NULL,NULL,"1",NULL,NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"none",NULL,"none","none","none","none","none","none","none","none",NULL,NULL,"",NULL,NULL,NULL,"4","none",NULL,"6",NULL,"3",NULL,NULL,NULL,NULL,NULL,NULL,"0","none",NULL,NULL,"1",NULL,NULL,NULL,"","Islam","মো: আরিফুল ইসলাম","ভাই","Lalmonirhat","01717452764","","আমার নাম মেডিকেল","WebBazarBD","Six");
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1351",NULL,"4","webbazarbd24@gmail.com","MD ABRAR AFTAHI","মো: আবরার আফহাতী","Md Sahidul Islam","","26-Dec-2024:02:37","Lalmonirhat","","Rangpur","5520","01717452764",NULL,"1","2025","4","","0","1731939179.png","Mst Rokeya Khatun","","male","2024-11-15",NULL,"706462723","","MD_6071351","0fdb77d98aa0de5b1fdd84e79ca7305c","MD_1733909568","1","","","","","","","","","2",NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,"","none","","none","none","none","none","none","none","none","none","","","test","","","","4","none","","6","","3","1","1731481923","","","","","","Passport-No",NULL,NULL,"1",NULL,"",NULL,"","Islam","","","","","","",NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1352",NULL,"5","webbazarbd24@gmail.com","Al Imran","","YOUNOSH KHAN","","02-Dec-2024:21:51","Lalmonirhat",NULL,"kaliganj","5520","01636639783","","1","2025","4","","0","1731944700.jpg","Most shohida begum","","male","2024-11-14",NULL,"303359208",NULL,"Al_9711352","8ec619aefc02100e09b1c5b1839e8506","Al_1733909568","1","","","","","","","","","",NULL,"","","","","","","","","","none","","none","none","none","none","none","none",NULL,NULL,"","","","","","","4","none","","6",NULL,"3","1","1731587676",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"Islam",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1353",NULL,"7","webbazarbd24@gmail.com","MD ABRAR AFTAHI","asd","Md Sahidul Islam","","03-Dec-2024:36:21","Lalmonirhat",NULL,"Rangpur","5520","01717452764","","1","2025","5","","0","1731939179.png","Mst Rokeya Khatun","","male","2024-11-15",NULL,"438352511","1","MD_8901353","8fc8e223cc1b102394fb5dd7e3375f92","MD_1735176030","1","","","","","","","","","2",NULL,"","","","","","","","","","none","","none","none","none","none","none","none",NULL,NULL,"","","test","","","","4","none","","6",NULL,"3",NULL,"706462723",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"Islam",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1354",NULL,"9","webbazarbd24@gmail.com","Al Imran","","YOUNOSH KHAN","","20-Jan-2025:02:53","Lalmonirhat","","kaliganj","5520","01636639783",NULL,"1","2025","5","","0","1731944700.jpg","Most shohida begum","","male","2024-11-14",NULL,"707329758","1","Al_6591354","727145243a49df93f0b11d80c8d5f5d4","Al_1735176030","1","","","","","","","","","2",NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,"","none","","none","none","none","none","none","none","none","none","","","","","","","4","none","","8","","3",NULL,"303359208","","","","","","Passport-No",NULL,NULL,"1",NULL,"",NULL,"","Islam","","","","","","",NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1355",NULL,"11","webbazarbd24@gmail.com","MD ABRAR AFTAHI","asd","Md Sahidul Islam","","03-Dec-2024:36:21","Lalmonirhat",NULL,"Rangpur","5520","01717452764","","1","2025","6","","0","1731939179.png","Mst Rokeya Khatun","","male","2024-11-15",NULL,"58446217",NULL,"MD_4211355","a61d19d12e0de051c180b2e021c80a5b","MD_1735176044","1","","","","","","","","","2",NULL,"","","","","","","","","","none","","none","none","none","none","none","none",NULL,NULL,"","","test","","","","5","none","","6",NULL,"3",NULL,"706462723",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1361",NULL,"2012","456","hgfh","456","546","456","16-03-2025:09:02 AM","56","565","65","656","01713728112","5000","1","2025","1",NULL,"0","1742094123.png","5665","","male","27-03-2025","0","1742094123",NULL,NULL,NULL,NULL,"1",NULL,NULL,"","54+",NULL,NULL,NULL,NULL,"2",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"none",NULL,"none","none","none","none","none","none","none","none","2025-03-23","2025-03-28","654","46","01713728112",NULL,"4","B+",NULL,"6",NULL,"3",NULL,NULL,"565","56","56","56","01713728112","none",NULL,NULL,"1",NULL,NULL,"1","54664556","Islam",NULL,NULL,NULL,NULL,NULL,"",NULL,NULL);
INSERT INTO `student` (`id`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1362",NULL,NULL,"01713728112","hchfc1@gmail.com","01713728112","01713728112","01713728112","16-03-2025:08:34 PM","01713728112","01713728112","01713728112","01713728112","01713728112",NULL,"6","2025","3",NULL,"0","1742135678.png","01713728112","01713728112","male","13-03-2025",NULL,"1742135678",NULL,NULL,NULL,NULL,"0",NULL,NULL,"01713728112","01713728112",NULL,NULL,NULL,NULL,"2",NULL,"01713728112",NULL,"01713728112","01713728112","1999","01713728112","01713728112","Jashore",NULL,"none",NULL,"none","none","none","none","none","none","none","none","2025-03-16","2025-03-21","01713728112","01713728112","01713728112",NULL,"4","A-",NULL,"6",NULL,"3",NULL,NULL,"01713728112","01713728112","01713728112","01713728112","01713728112","none",NULL,NULL,"0",NULL,NULL,"1","01713728112","Islam",NULL,NULL,NULL,NULL,NULL,"",NULL,NULL);


-- Table structure for table `student_admission_fee`
DROP TABLE IF EXISTS `student_admission_fee`;
CREATE TABLE `student_admission_fee` (
  `s_a_id` int(20) NOT NULL AUTO_INCREMENT,
  `s_t_id` int(20) NOT NULL,
  `fee_amount` int(20) NOT NULL,
  `fee_status` int(5) NOT NULL,
  `fee_mobile` varchar(100) NOT NULL,
  `fee_email` varchar(250) DEFAULT NULL,
  `fee_payment_method` varchar(100) DEFAULT NULL,
  `fee_payment_type` varchar(100) DEFAULT NULL,
  `fee_temp_id` varchar(250) DEFAULT NULL,
  `fee_temp_pass` varchar(250) DEFAULT NULL,
  `admission_submit_date` varchar(200) DEFAULT NULL,
  `admission_expire_date` varchar(200) DEFAULT NULL,
  `otp_time` int(10) NOT NULL DEFAULT 0,
  `s_dates` varchar(100) DEFAULT NULL,
  `tran_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`s_a_id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `student_admission_fee`
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("30","1362","10","1","01713728112","01713728112","ssl_commerce","SSL-Commerce","68A1362ZE","474271","1742135678","1742222078","0","2025-03-16","SSLCZ_30_67d6e49b1f213");
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("31","1363","10","1","01713728112","01713728112","ssl_commerce","SSL-Commerce","63A1363ZE","375025","1742207561","1742293961","0","2025-03-17","SSLCZ_31_67d7fa8764504");
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("32","1364","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"11A1364ZE","803834","1742222062","1742308462","0","2025-03-17",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("33","1365","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"89A1365ZE","826374","1742222371","1742308771","0","2025-03-17",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("34","1366","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"72A1366ZE","355403","1742222472","1742308872","0","2025-03-17",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("35","1367","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"93A1367ZE","314673","1742222648","1742309048","0","2025-03-17",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("36","1368","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"12A1368ZE","676306","1742267841","1742354241","0","2025-03-18",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("37","1369","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"79A1369ZE","727036","1742267861","1742354261","0","2025-03-18",NULL);
INSERT INTO `student_admission_fee` (`s_a_id`, `s_t_id`, `fee_amount`, `fee_status`, `fee_mobile`, `fee_email`, `fee_payment_method`, `fee_payment_type`, `fee_temp_id`, `fee_temp_pass`, `admission_submit_date`, `admission_expire_date`, `otp_time`, `s_dates`, `tran_id`) VALUES("38","1370","10","0","01713728112","mdibrahimbashar1@gmail.com",NULL,NULL,"11A1370ZE","283825","1742267910","1742354310","0","2025-03-18",NULL);


-- Table structure for table `student_esf`
DROP TABLE IF EXISTS `student_esf`;
CREATE TABLE `student_esf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi` int(11) NOT NULL,
  `sname` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `fname` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `mName` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `contact` varchar(255) NOT NULL,
  `image` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `student_esf`
INSERT INTO `student_esf` (`id`, `regi`, `sname`, `fname`, `mName`, `contact`, `image`) VALUES("21","1","Md Ashraful Islam","Md Shofiqur Rahman","Most shohida begum","01717452764","");


-- Table structure for table `student_id_card_template`
DROP TABLE IF EXISTS `student_id_card_template`;
CREATE TABLE `student_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(12) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `student_id_card_template`
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1704968643_Student_ID_Card_1.png","1","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1704917747_Student_ID_Card_2.png","2","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1705023464_Student_ID_Card_3.png","3","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1704917973_Student_ID_Card_4.png","4","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("5","image/template_1705032093_Student_ID_Card_5.png","5","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("6","image/template_1704918427_Student_ID_Card_6.png","6","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("7","image/template_1704918438_Student_ID_Card_7.png","7","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("8","image/template_1706749036_Student_ID_Card_8.png","8","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("9","image/template_1704918461_Student_ID_Card_9.png","9","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("10","image/template_1704918471_Student_ID_Card_10.png","10","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("11","image/template_1716944252_Student_ID_Card_11.png","11","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("12","image/template_1706146186_Student_ID_Card_12.png","12","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("13","image/template_1707138939_Student_ID_Card_13.png","13","1","0","0","1");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("14","image/template_1719236779_Student_ID_Card_14.png","14","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("15","image/template_1720659225_Student_ID_Card_14.png","15","1","0","0","0");
INSERT INTO `student_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("16","image/template_1723337487_Student_ID_Card_16.png","16","1","0","0","0");


-- Table structure for table `student_old`
DROP TABLE IF EXISTS `student_old`;
CREATE TABLE `student_old` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment` varchar(500) DEFAULT NULL,
  `registation_com_id` varchar(250) DEFAULT NULL,
  `regi` varchar(250) DEFAULT NULL,
  `emailid` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `sname` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `std_name_b` varchar(255) DEFAULT NULL,
  `fname` varchar(30) DEFAULT NULL,
  `f_name_b` varchar(255) DEFAULT NULL,
  `joindate` varchar(100) DEFAULT NULL,
  `about_v` varchar(25) DEFAULT NULL,
  `about_p` varchar(255) DEFAULT NULL,
  `about_t` varchar(25) DEFAULT NULL,
  `about_d` varchar(25) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `fees` varchar(11) DEFAULT NULL,
  `branch` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `s_year` varchar(50) DEFAULT NULL,
  `course` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` varchar(11) DEFAULT NULL,
  `delete_status` varchar(11) NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mName` varchar(255) DEFAULT NULL,
  `m_name_b` varchar(255) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `birth_day` varchar(255) DEFAULT NULL,
  `discount` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `tmp_id` varchar(250) DEFAULT NULL,
  `roll_2` varchar(250) DEFAULT NULL,
  `user_id` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `show_pass` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT '0' COMMENT '1=Active, 0=False',
  `st_union_name` varchar(255) DEFAULT NULL,
  `p_post_name` varchar(255) DEFAULT NULL,
  `guardian_year_income` varchar(255) DEFAULT NULL,
  `st_guardian_profession` varchar(255) DEFAULT NULL,
  `st_guardian_vill` varchar(255) DEFAULT NULL,
  `st_guardian_post` varchar(255) DEFAULT NULL,
  `st_guardian_upzi` varchar(255) DEFAULT NULL,
  `st_guardian_dist` varchar(255) DEFAULT NULL,
  `quota_student_old` varchar(255) DEFAULT NULL,
  `institution_Name_b_ssc` varchar(255) DEFAULT NULL,
  `institution_Name_e_ssc` varchar(255) DEFAULT NULL,
  `institution_adr_ssc` varchar(255) DEFAULT NULL,
  `roll_no_ssc` varchar(255) DEFAULT NULL,
  `regi_no_ssc` varchar(255) DEFAULT NULL,
  `pass_year_ssc` varchar(255) DEFAULT NULL,
  `group_trade_ssc` varchar(255) DEFAULT NULL,
  `gpa_ssc` varchar(255) DEFAULT NULL,
  `board_ssc` varchar(255) DEFAULT NULL,
  `institution_Name_b_hsc` varchar(255) DEFAULT NULL,
  `institution_Name_e_hsc` varchar(255) DEFAULT NULL,
  `institution_adr_hsc` varchar(255) DEFAULT NULL,
  `roll_no_hsc` varchar(255) DEFAULT NULL,
  `regi_no_hsc` varchar(255) DEFAULT NULL,
  `pass_year_hsc` varchar(255) DEFAULT NULL,
  `group_trade_hsc` varchar(255) DEFAULT NULL,
  `gpa_hsc` varchar(255) DEFAULT NULL,
  `board_hsc` varchar(255) DEFAULT NULL,
  `jsc` longtext DEFAULT NULL,
  `masters` longtext DEFAULT NULL,
  `f_birth_day` varchar(255) DEFAULT NULL,
  `m_birth_day` varchar(255) DEFAULT NULL,
  `st_national_bir_id` varchar(255) DEFAULT NULL,
  `f_national_bir_id` varchar(255) DEFAULT NULL,
  `m_national_bir_id` varchar(255) DEFAULT NULL,
  `per_union_name` varchar(255) DEFAULT NULL,
  `academic_year_name_bn` varchar(255) DEFAULT NULL,
  `blood_group_st` varchar(255) DEFAULT NULL,
  `board_shotcord` varchar(255) DEFAULT NULL,
  `class_section_name` varchar(255) DEFAULT NULL,
  `qr_code_generator` varchar(100) DEFAULT NULL,
  `shift_name` varchar(255) DEFAULT NULL,
  `permision` varchar(2) DEFAULT NULL,
  `be_tmp` varchar(11) DEFAULT NULL,
  `p_ad_v` varchar(100) DEFAULT NULL,
  `p_ad_t` varchar(100) DEFAULT NULL,
  `p_ad_p` varchar(100) DEFAULT NULL,
  `p_ad_d` varchar(100) DEFAULT NULL,
  `f_contact_number` varchar(100) DEFAULT NULL,
  `id_type` varchar(250) DEFAULT NULL,
  `expire_date` varchar(255) DEFAULT NULL,
  `joined_date` varchar(255) DEFAULT NULL,
  `status_approved` varchar(255) NOT NULL DEFAULT '0' COMMENT '0 Panding, 1 Approved',
  `trade_name` varchar(255) DEFAULT NULL,
  `s_mother_profession` varchar(255) DEFAULT NULL,
  `institution_name_ex` varchar(255) DEFAULT NULL,
  `present_school_name` varchar(255) DEFAULT NULL,
  `religion` varchar(255) DEFAULT NULL,
  `guardian_name` varchar(255) DEFAULT NULL,
  `relationship_parent` varchar(255) DEFAULT NULL,
  `parental_address` varchar(255) DEFAULT NULL,
  `guardian_mobile` varchar(255) DEFAULT NULL,
  `whatsapp_no` varchar(255) DEFAULT NULL,
  `medical_info` varchar(250) DEFAULT NULL,
  `previous_institute_name` varchar(255) DEFAULT NULL,
  `previous_institute_class` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1360 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `student_old`
INSERT INTO `student_old` (`id`, `comment`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student_old`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1350",NULL,NULL,"33","webbazarbd24@gmail.com","aaa","","YOUNOSH KHAN",NULL,"18-11-2024:09:50 PM","Lalmonirhat","lalmonirhat","kaliganj","5520","01717452764",NULL,"1","2024","3",NULL,"0","1731945044.png","Most shohida begum",NULL,"female","2024-10-29",NULL,"1731945044",NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"none",NULL,"none","none","none","none","none","none","none","none",NULL,NULL,"",NULL,NULL,NULL,"4","none",NULL,"6",NULL,"3",NULL,NULL,NULL,NULL,NULL,NULL,"0","none",NULL,NULL,"0",NULL,NULL,NULL,"","Islam","মো: আরিফুল ইসলাম","ভাই","Lalmonirhat","01717452764","","আমার নাম মেডিকেল","WebBazarBD","Six");
INSERT INTO `student_old` (`id`, `comment`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student_old`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1351",NULL,"","245","webbazarbd24@gmail.com","Al Imran","আল ইমরান","YOUNOSH KHAN","ইউনুস খান","02-Dec-2024:21:51","Lalmonirhat","lalmonirhat","kaliganj","5520","01713728112","","1","2024","3","","0","1731944700.jpg","Most shohida begum","শহীদা বেগম","male","2024-11-14","","1731587676","2003","Al_3791349","d6a99d4bc68601cfc41346762dbc22d5","Al_1733376286","1","","","","","","","","","","","","","","","","","","","","none","","none","none","none","none","none","none","none","none","","","","","","","4","none","","6","","3","","","","","","","0","Passport-No","","","0","","","","","Islam","মো: আরিফুল ইসলাম","ভাই","01717452764","01717452764","","","","");
INSERT INTO `student_old` (`id`, `comment`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student_old`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1353","dgfdghfdhfd","","235","webbazarbd24@gmail.com","Al Imran","আল ইমরান","YOUNOSH KHAN","ইউনুস খান","02-Dec-2024:21:51","Lalmonirhat","lalmonirhat","kaliganj","5520","01713728112","","1","2024","3","","0","1731944700.jpg","Most shohida begum","শহীদা বেগম","male","2024-11-14","","1731587676","2003","Al_3791349","d6a99d4bc68601cfc41346762dbc22d5","Al_1733376286","1","","","","","","","","",NULL,"","","","","","","","","","","none","","none","none","none","none","none","none","none","none","","","","","","","4","none","","6","","3","","","","","","","0","Passport-No","","","1","","","","","Islam","মো: আরিফুল ইসলাম","ভাই","01717452764","01717452764","","","","");
INSERT INTO `student_old` (`id`, `comment`, `registation_com_id`, `regi`, `emailid`, `sname`, `std_name_b`, `fname`, `f_name_b`, `joindate`, `about_v`, `about_p`, `about_t`, `about_d`, `contact`, `fees`, `branch`, `s_year`, `course`, `balance`, `delete_status`, `image`, `mName`, `m_name_b`, `gender`, `birth_day`, `discount`, `tmp_id`, `roll_2`, `user_id`, `password`, `show_pass`, `status`, `st_union_name`, `p_post_name`, `guardian_year_income`, `st_guardian_profession`, `st_guardian_vill`, `st_guardian_post`, `st_guardian_upzi`, `st_guardian_dist`, `quota_student_old`, `institution_Name_b_ssc`, `institution_Name_e_ssc`, `institution_adr_ssc`, `roll_no_ssc`, `regi_no_ssc`, `pass_year_ssc`, `group_trade_ssc`, `gpa_ssc`, `board_ssc`, `institution_Name_b_hsc`, `institution_Name_e_hsc`, `institution_adr_hsc`, `roll_no_hsc`, `regi_no_hsc`, `pass_year_hsc`, `group_trade_hsc`, `gpa_hsc`, `board_hsc`, `jsc`, `masters`, `f_birth_day`, `m_birth_day`, `st_national_bir_id`, `f_national_bir_id`, `m_national_bir_id`, `per_union_name`, `academic_year_name_bn`, `blood_group_st`, `board_shotcord`, `class_section_name`, `qr_code_generator`, `shift_name`, `permision`, `be_tmp`, `p_ad_v`, `p_ad_t`, `p_ad_p`, `p_ad_d`, `f_contact_number`, `id_type`, `expire_date`, `joined_date`, `status_approved`, `trade_name`, `s_mother_profession`, `institution_name_ex`, `present_school_name`, `religion`, `guardian_name`, `relationship_parent`, `parental_address`, `guardian_mobile`, `whatsapp_no`, `medical_info`, `previous_institute_name`, `previous_institute_class`) VALUES("1354"," btrf","","23","webbazarbd24@gmail.com","Al Imran","আল ইমরান","YOUNOSH KHAN","ইউনুস খান","02-Dec-2024:21:51","Lalmonirhat","lalmonirhat","kaliganj","5520","01713728112","","1","2024","3","","0","1731944700.jpg","Most shohida begum","শহীদা বেগম","male","2024-11-14","","1731587676","2003","Al_3791349","d6a99d4bc68601cfc41346762dbc22d5","Al_1733376286","1","","","","","","","","",NULL,"","","","","","","","","","","none","","none","none","none","none","none","none","none","none","","","","","","","4","none","","6","","3","","","","","","","0","Passport-No","","","1","","","","","Islam","মো: আরিফুল ইসলাম","ভাই","01717452764","01717452764","","","","");


-- Table structure for table `student_position`
DROP TABLE IF EXISTS `student_position`;
CREATE TABLE `student_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `total_mark` float NOT NULL,
  `student_id` int(11) NOT NULL,
  `s_year` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `student_position`
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("1","3","0","1","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("2","3","0","2","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("3","3","0","0","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("4","3","0","2","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("5","3","263","3","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("6","3","263","4","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("7","3","1063","5","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("8","3","263","6","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("9","3","263","7","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("10","3","268","8","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("11","3","263","9","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("12","3","0","10","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("13","3","0","0","2024");
INSERT INTO `student_position` (`id`, `class_id`, `total_mark`, `student_id`, `s_year`) VALUES("14","3","0","1","2024");


-- Table structure for table `student_subject_selection`
DROP TABLE IF EXISTS `student_subject_selection`;
CREATE TABLE `student_subject_selection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_subject` (`student_id`,`subject_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `student_subject_selection`


-- Table structure for table `student_time`
DROP TABLE IF EXISTS `student_time`;
CREATE TABLE `student_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(250) NOT NULL,
  `department` varchar(250) NOT NULL,
  `section` varchar(250) NOT NULL,
  `shift` varchar(250) NOT NULL,
  `year` varchar(250) NOT NULL,
  `academic_year` varchar(250) NOT NULL,
  `start_form` varchar(250) NOT NULL,
  `start_to` varchar(250) NOT NULL,
  `late_attend_start` varchar(250) NOT NULL,
  `late_attend_end` varchar(250) NOT NULL,
  `end_form` varchar(250) NOT NULL,
  `end_to` varchar(2502) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `student_time`
INSERT INTO `student_time` (`id`, `class`, `department`, `section`, `shift`, `year`, `academic_year`, `start_form`, `start_to`, `late_attend_start`, `late_attend_end`, `end_form`, `end_to`, `status`) VALUES("17","3","1","6","1","","","09:30","10:00","11:01","00:05","11:22","11:40","1");


-- Table structure for table `student_update_info`
DROP TABLE IF EXISTS `student_update_info`;
CREATE TABLE `student_update_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `log_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `creator_by` int(30) NOT NULL,
  `creator_by_sub_user` int(11) NOT NULL,
  `is_read` text NOT NULL,
  `is_red_sub_user` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `student_update_info`


-- Table structure for table `study_type_v3`
DROP TABLE IF EXISTS `study_type_v3`;
CREATE TABLE `study_type_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `study_type_v3`
INSERT INTO `study_type_v3` (`id`, `name`, `details`, `date`) VALUES("1","Home Work","Home Work","2025-01-08 09:13:47");
INSERT INTO `study_type_v3` (`id`, `name`, `details`, `date`) VALUES("2","Class Test","Class Test","2025-01-08 09:14:19");


-- Table structure for table `sub_user`
DROP TABLE IF EXISTS `sub_user`;
CREATE TABLE `sub_user` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `username` varchar(15) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `password` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `contact` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `emailid` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `sub_user`
INSERT INTO `sub_user` (`id`, `name`, `username`, `password`, `contact`, `emailid`, `delete_status`) VALUES("2","user_1","user","e10adc3949ba59abbe56e057f20f883e","01717452764","abc@gmail.com","0");


-- Table structure for table `teacher_blog`
DROP TABLE IF EXISTS `teacher_blog`;
CREATE TABLE `teacher_blog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(100) NOT NULL,
  `blog_title` varchar(255) NOT NULL,
  `class_name` int(11) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `subject_time` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `start_date` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `teacher_blog`
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("4","AS_6027","asdfasdf","9","2","23:14","adfasdfasdf","2022-04-09","1","2022-04-02 09:24:13");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("10","AS_6865","asdfasdf","9","2,3","00:00,00:00","asdfasdfasd","2022-04-07","1","2022-04-02 13:40:21");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("11","AS_6865","asdfasdf","9","2,3","19:58,19:52","adfasdfas","2022-04-07","1","2022-04-02 14:52:32");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("12","AS_9882","sadfasdfa","9","3","16:40","dsklfaslk laslalsdakjflkasd flkasdj flksadj flksad flksa dlkf aslkf sadfasd","2022-04-19","1","2022-04-09 14:40:04");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("13","AS_9882","sadfasdfasd","9","3","06:25","sdfasdfasdfasdf","2022-04-10","1","2022-04-09 16:23:53");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("14","48","","0","","","","","0","2024-02-26 17:45:34");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("15","48","","0","","","","","0","2024-02-26 17:45:46");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("16","48","","0","","","","","0","2024-02-26 17:46:11");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("17","48","","0","","","","","0","2024-02-26 17:47:35");
INSERT INTO `teacher_blog` (`id`, `teacher_id`, `blog_title`, `class_name`, `subject`, `subject_time`, `message`, `start_date`, `status`, `create_at`) VALUES("18","20241","tt","3","17","05:12","আমার সোনার আংলা","2025-01-07","1","2025-01-07 17:12:33");


-- Table structure for table `teacher_id_card_template`
DROP TABLE IF EXISTS `teacher_id_card_template`;
CREATE TABLE `teacher_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(12) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `teacher_id_card_template`
INSERT INTO `teacher_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1704920823_teacher_id_card_1.png","1","1","0","0","0");
INSERT INTO `teacher_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1724665349_teacher_id_card_2.png","2","1","0","0","0");
INSERT INTO `teacher_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1707184223_teacher_id_card_3.png","3","1","0","0","1");
INSERT INTO `teacher_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1710475169_teacher_id_card_4.png","4","1","0","0","0");
INSERT INTO `teacher_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("5","image/template_1720245333_teacher_id_card_5.png","5","1","0","0","0");


-- Table structure for table `teacher_registration_data`
DROP TABLE IF EXISTS `teacher_registration_data`;
CREATE TABLE `teacher_registration_data` (
  `t_id` int(20) NOT NULL AUTO_INCREMENT,
  `image` varchar(250) DEFAULT NULL,
  `t_name_b` varchar(255) DEFAULT NULL,
  `t_name_e` varchar(255) DEFAULT NULL,
  `f_name_b` varchar(255) DEFAULT NULL,
  `f_name_e` varchar(255) DEFAULT NULL,
  `m_name_b` varchar(255) DEFAULT NULL,
  `m_name_e` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `t_villege` varchar(255) DEFAULT NULL,
  `t_post_name` varchar(255) DEFAULT NULL,
  `t_upzila` varchar(255) DEFAULT NULL,
  `t_zila` varchar(255) DEFAULT NULL,
  `t_mobile` varchar(255) DEFAULT NULL,
  `t_ful_address` varchar(255) DEFAULT NULL,
  `t_guardian_mobile` varchar(255) DEFAULT NULL,
  `t_subject_name` varchar(255) DEFAULT NULL,
  `t_birth_day` varchar(255) DEFAULT NULL,
  `national_id` varchar(250) DEFAULT NULL,
  `t_nationality` varchar(255) DEFAULT NULL,
  `t_religion` varchar(255) DEFAULT NULL,
  `t_blood_group` varchar(255) DEFAULT NULL,
  `t_email` varchar(255) DEFAULT NULL,
  `t_designation` varchar(255) DEFAULT NULL,
  `t_skill_know` varchar(400) DEFAULT NULL,
  `t_jsc_roll` varchar(255) DEFAULT NULL,
  `t_jsc_subject` varchar(255) DEFAULT NULL,
  `t_jsc_passing_y` varchar(255) DEFAULT NULL,
  `t_jsc_gpa` varchar(255) DEFAULT NULL,
  `t_jsc_board` varchar(255) DEFAULT NULL,
  `t_ssc_roll` varchar(255) DEFAULT NULL,
  `t_ssc_subject` varchar(255) DEFAULT NULL,
  `t_ssc_passing_y` varchar(255) DEFAULT NULL,
  `t_ssc_gpa` varchar(255) DEFAULT NULL,
  `t_ssc_board` varchar(255) DEFAULT NULL,
  `t_hsc_roll` varchar(255) DEFAULT NULL,
  `t_hsc_subject` varchar(255) DEFAULT NULL,
  `t_hsc_passing_y` varchar(255) DEFAULT NULL,
  `t_hsc_gpa` varchar(255) DEFAULT NULL,
  `t_hsc_board` varchar(255) DEFAULT NULL,
  `t_dhons_roll` varchar(255) DEFAULT NULL,
  `t_dhons_subject` varchar(255) DEFAULT NULL,
  `t_dhons_passing_y` varchar(255) DEFAULT NULL,
  `t_dhons_gpa` varchar(255) DEFAULT NULL,
  `t_dhons_board` varchar(255) DEFAULT NULL,
  `t_mastas_roll` varchar(255) DEFAULT NULL,
  `t_mastas_subject` varchar(255) DEFAULT NULL,
  `t_mastas_passing_y` varchar(255) DEFAULT NULL,
  `t_mastas_gpa` varchar(255) DEFAULT NULL,
  `t_mastas_board` varchar(255) DEFAULT NULL,
  `techer_image` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL COMMENT '0 Panding, 1 Approved	',
  `tmp_id` varchar(11) NOT NULL DEFAULT '0',
  `form_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `teacher_id` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `password_show` varchar(255) DEFAULT NULL,
  `qr_code_generator` varchar(100) DEFAULT NULL,
  `objective` longtext DEFAULT NULL,
  `ssc` longtext DEFAULT NULL,
  `hsc` longtext DEFAULT NULL,
  `diploma` longtext DEFAULT NULL,
  `bsc` longtext DEFAULT NULL,
  `msc` longtext DEFAULT NULL,
  `experience` longtext DEFAULT NULL,
  `skill` longtext DEFAULT NULL,
  `links` longtext DEFAULT NULL,
  `same_add` longtext DEFAULT NULL,
  `joined_date` varchar(255) DEFAULT NULL,
  `expire_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `teacher_registration_data`
INSERT INTO `teacher_registration_data` (`t_id`, `image`, `t_name_b`, `t_name_e`, `f_name_b`, `f_name_e`, `m_name_b`, `m_name_e`, `gender`, `t_villege`, `t_post_name`, `t_upzila`, `t_zila`, `t_mobile`, `t_ful_address`, `t_guardian_mobile`, `t_subject_name`, `t_birth_day`, `national_id`, `t_nationality`, `t_religion`, `t_blood_group`, `t_email`, `t_designation`, `t_skill_know`, `t_jsc_roll`, `t_jsc_subject`, `t_jsc_passing_y`, `t_jsc_gpa`, `t_jsc_board`, `t_ssc_roll`, `t_ssc_subject`, `t_ssc_passing_y`, `t_ssc_gpa`, `t_ssc_board`, `t_hsc_roll`, `t_hsc_subject`, `t_hsc_passing_y`, `t_hsc_gpa`, `t_hsc_board`, `t_dhons_roll`, `t_dhons_subject`, `t_dhons_passing_y`, `t_dhons_gpa`, `t_dhons_board`, `t_mastas_roll`, `t_mastas_subject`, `t_mastas_passing_y`, `t_mastas_gpa`, `t_mastas_board`, `techer_image`, `status`, `tmp_id`, `form_date`, `teacher_id`, `password`, `password_show`, `qr_code_generator`, `objective`, `ssc`, `hsc`, `diploma`, `bsc`, `msc`, `experience`, `skill`, `links`, `same_add`, `joined_date`, `expire_date`) VALUES("1","1705904745.jpg","মো: আশরাফুল ইসলাম","Md Ashraful Islam","Shofiqur","Shofiqur","Shofiqur","Shofiqur","male","Kashiram","Karimpur","Kaliganj","Lalmonirhat","01717452764","1250, Mirpur, Dhaka","01717452764","","2024-01-22","5555","Bangladeshi","Islam","A+","webbazarbd24@gmail.com","Principal","","","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","","",NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,"1705904745.jpg","1","1705904745","2024-11-16 12:58:40","20241","505931",NULL,"t_1646784129","\"Self-motivated team player with nine years of experience seeking a position as a lead web developer with Next Generation Web Development where I can apply my advanced knowledge of web design with my leadership abilities to meet client needs and exceed their expectations.\"","{\"school\":\"Karimpur high school\",\"ssc_exams\":\"SSC\",\"roll\":\"2832828\",\"reg\":\"83282828\",\"p_year\":\"1999\",\"department\":\"Humanetes\",\"gpa\":\"2.00\",\"board\":\"Cumilla\"}","{\"school\":\"Karim Uddin Degree Cloege\",\"hsc_exam\":\"TEST\",\"roll\":\"110824\",\"reg\":\"\",\"p_year\":\"2003\",\"department\":\"Busnes\",\"gpa\":\"5.00\",\"board\":\"Sylhet\"}","{\"school\":\"Karimpur high school\",\"diploma_exam\":\"TEST\",\"roll\":\"8282828\",\"reg\":\"82828\",\"p_year\":\"1990\",\"department\":\"82828\",\"gpa\":\"2.00\",\"board\":\"Technical\"}","{\"school\":\"Karim Uddin Degree Cloege222\",\"Honours_exam\":\"TEST\",\"roll\":\"5.35\",\"reg\":\"53535\",\"p_year\":\"2024\",\"department\":\"Karim Uddin Degree Cloege333\",\"gpa\":\"535\",\"board\":\"Karim Uddin Degree Cloege\"}","{\"school\":\"National University\",\"Masters_exam\":\"sdad\",\"roll\":\"5325\",\"reg\":\"53535\",\"p_year\":\"2024\",\"department\":\"Bangla\",\"gpa\":\"7527\",\"board\":\"Karim Uddin Degree Cloege\"}","[{\"ex_join_date\":\"2024-07-02\",\"ex_end_date\":\"2024-07-02\",\"ex_designation\":\"Pincipal\",\"ex_company\":\"webbazarbd\",\"ex_location\":\"Rangpur\"}]","[{\"skill_name\":\"Computer\",\"skill_level\":\"5\"}]","{\"f\":\"       facebook.com\\/webbazarb\",\"l\":\"       facebook.com\\/webbazarb\",\"g\":\"       facebook.com\\/webbazarb\\/\",\"w\":\"       facebook.com\\/webbazarb\"}","{\"p_v\":\"Kashiram\",\"p_p\":\"Karimpur\",\"p_u\":\"Kaliganj\",\"p_z\":\"Lalmonirhat\",\"p_f_ad\":\"1250, Mirpur, Dhaka\"}","2024-02-01","2024-08-26");
INSERT INTO `teacher_registration_data` (`t_id`, `image`, `t_name_b`, `t_name_e`, `f_name_b`, `f_name_e`, `m_name_b`, `m_name_e`, `gender`, `t_villege`, `t_post_name`, `t_upzila`, `t_zila`, `t_mobile`, `t_ful_address`, `t_guardian_mobile`, `t_subject_name`, `t_birth_day`, `national_id`, `t_nationality`, `t_religion`, `t_blood_group`, `t_email`, `t_designation`, `t_skill_know`, `t_jsc_roll`, `t_jsc_subject`, `t_jsc_passing_y`, `t_jsc_gpa`, `t_jsc_board`, `t_ssc_roll`, `t_ssc_subject`, `t_ssc_passing_y`, `t_ssc_gpa`, `t_ssc_board`, `t_hsc_roll`, `t_hsc_subject`, `t_hsc_passing_y`, `t_hsc_gpa`, `t_hsc_board`, `t_dhons_roll`, `t_dhons_subject`, `t_dhons_passing_y`, `t_dhons_gpa`, `t_dhons_board`, `t_mastas_roll`, `t_mastas_subject`, `t_mastas_passing_y`, `t_mastas_gpa`, `t_mastas_board`, `techer_image`, `status`, `tmp_id`, `form_date`, `teacher_id`, `password`, `password_show`, `qr_code_generator`, `objective`, `ssc`, `hsc`, `diploma`, `bsc`, `msc`, `experience`, `skill`, `links`, `same_add`, `joined_date`, `expire_date`) VALUES("63","1742094257.png","01713728112","01713728112","01713728112","01713728112","01713728112","01713728112","female","01713728112","01713728112","01713728112","01713728112","01713728112","01713728112","01713728112",NULL,"2025-03-22","01713728112","01713728112","01713728112","B+","mdibrahimbashar1@gmail.com","01713728112",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1742094257.png","1","1742094257","2025-03-16 09:13:47","63","922728",NULL,NULL,"","none","none","none","{\"school\":\"01713728112\",\"Honours_exam\":\"Honours\\/BSC\\/Fazil\\/Equivalent\",\"roll\":\"01713728112\",\"reg\":\"01713728112\",\"p_year\":\"1995\",\"department\":\"01713728112\",\"gpa\":\"\",\"board\":\"01713728112\"}","none","none","none","{\"f\":\"01713728112\",\"l\":\"01713728112\",\"g\":\"\",\"w\":\"\"}","{\"p_v\":\"01713728112\",\"p_p\":\"01713728112\",\"p_u\":\"01713728112\",\"p_z\":\"01713728112\",\"p_f_ad\":\"01713728112\"}",NULL,NULL);


-- Table structure for table `teacher_subject`
DROP TABLE IF EXISTS `teacher_subject`;
CREATE TABLE `teacher_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(20) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `subject_time` varchar(100) DEFAULT NULL,
  `t_s_id` varchar(255) DEFAULT NULL,
  `branch` varchar(250) DEFAULT NULL,
  `status` varchar(11) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `teacher_subject`
INSERT INTO `teacher_subject` (`id`, `course_id`, `subject`, `subject_time`, `t_s_id`, `branch`, `status`, `timestamp`) VALUES("20","3","22",NULL,"20241","Humanities","0","2024-11-25 08:31:25");
INSERT INTO `teacher_subject` (`id`, `course_id`, `subject`, `subject_time`, `t_s_id`, `branch`, `status`, `timestamp`) VALUES("29","3","44",NULL,"20241","General","0","2024-11-29 18:23:22");
INSERT INTO `teacher_subject` (`id`, `course_id`, `subject`, `subject_time`, `t_s_id`, `branch`, `status`, `timestamp`) VALUES("30","3","21",NULL,"63","General","0","2025-03-30 13:03:52");
INSERT INTO `teacher_subject` (`id`, `course_id`, `subject`, `subject_time`, `t_s_id`, `branch`, `status`, `timestamp`) VALUES("31","3","44",NULL,"63","General","0","2025-03-30 13:03:52");


-- Table structure for table `teacher_time`
DROP TABLE IF EXISTS `teacher_time`;
CREATE TABLE `teacher_time` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(250) NOT NULL,
  `start_from` varchar(250) NOT NULL,
  `start_to` varchar(250) NOT NULL,
  `late_start` varchar(250) NOT NULL,
  `late_end` varchar(250) NOT NULL,
  `end_form` varchar(250) NOT NULL,
  `end_to` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `teacher_time`


-- Table structure for table `techer_p`
DROP TABLE IF EXISTS `techer_p`;
CREATE TABLE `techer_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `t_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(250) NOT NULL,
  `f_name` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `m_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `d_birth` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `nationality` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `blood_group` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `marital_status` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `contact_address` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `contract` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `email_a` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `skill_know` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `techer_image` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `designation` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `techer_qcode` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `techer_p`
INSERT INTO `techer_p` (`id`, `t_id`, `name`, `f_name`, `m_name`, `d_birth`, `nationality`, `blood_group`, `marital_status`, `contact_address`, `contract`, `email_a`, `skill_know`, `techer_image`, `designation`, `techer_qcode`) VALUES("1","502","ফজলুল হক","আলিমুল হক","ফাতেমাতুজ জোহরা","    30-12-1989","bangldshi","    A+","Unmarit","Post-Karimpur, Upzilla-Kaliganj","01717452764","abc@gmail.com","Computer ","pincipal.jpg","Assistant Techer  ","IMG_20211111_163112.jpg");
INSERT INTO `techer_p` (`id`, `t_id`, `name`, `f_name`, `m_name`, `d_birth`, `nationality`, `blood_group`, `marital_status`, `contact_address`, `contract`, `email_a`, `skill_know`, `techer_image`, `designation`, `techer_qcode`) VALUES("2","501","Md Nur Islam","Jobbar","Amana","      30-12-1989","bangldshi","      A+","Unmarit","Post-Karimpur, Upzilla-Kaliganj","01717452765","abc@gmail.com","Computer ","online.jpg2.jpg","Assistant Techer  ","folwerWithoutname-removebg-preview.png");


-- Table structure for table `testimonial_id_card_template`
DROP TABLE IF EXISTS `testimonial_id_card_template`;
CREATE TABLE `testimonial_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `testimonial_id_card_template`
INSERT INTO `testimonial_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1704969100_Testimonial_Bangla_1.png","1","1","0","0","0");
INSERT INTO `testimonial_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1704961801_Testimonial_English_2.png","2","1","0","0","0");
INSERT INTO `testimonial_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1704961993_Testimonial_English_3.png","3","1","0","0","1");


-- Table structure for table `title_text_all`
DROP TABLE IF EXISTS `title_text_all`;
CREATE TABLE `title_text_all` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title_text_b` varchar(255) NOT NULL,
  `title_text_e` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `title_text_all`
INSERT INTO `title_text_all` (`id`, `title_text_b`, `title_text_e`) VALUES("1","বেষ্ট আফ আমার স্কুল","ওয়েব বাজার বিডি স্মার্ট স্কুল");


-- Table structure for table `trade_name`
DROP TABLE IF EXISTS `trade_name`;
CREATE TABLE `trade_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trade_name_bangla` varchar(255) NOT NULL,
  `trade_name_english` varchar(255) NOT NULL,
  `trade_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `trade_name`
INSERT INTO `trade_name` (`id`, `trade_name_bangla`, `trade_name_english`, `trade_code`) VALUES("1","বেসিক ট্রেড (৩৬০ ঘন্টা )","Basic Trade (360 hours)","76");
INSERT INTO `trade_name` (`id`, `trade_name_bangla`, `trade_name_english`, `trade_code`) VALUES("2","অ্যাডভান্সড সার্টিফিকেট","Advanced Certificate","99");


-- Table structure for table `transcript_title_text_all`
DROP TABLE IF EXISTS `transcript_title_text_all`;
CREATE TABLE `transcript_title_text_all` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title_text_e` varchar(255) NOT NULL,
  `exam_text` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `transcript_title_text_all`
INSERT INTO `transcript_title_text_all` (`id`, `title_text_e`, `exam_text`) VALUES("1","Academic Transcript","Annual Exam");


-- Table structure for table `trash_zi_payment`
DROP TABLE IF EXISTS `trash_zi_payment`;
CREATE TABLE `trash_zi_payment` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(100) DEFAULT NULL,
  `student_id` varchar(100) DEFAULT NULL,
  `course_id` varchar(100) DEFAULT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `payment_date` varchar(100) DEFAULT NULL,
  `total_payment` varchar(100) DEFAULT NULL,
  `due` varchar(100) DEFAULT NULL,
  `accept_name` varchar(100) DEFAULT NULL,
  `accept_id` varchar(100) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `description_name` varchar(255) DEFAULT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `discount` varchar(100) DEFAULT NULL,
  `discount_type` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `survey_comment` varchar(100) DEFAULT NULL,
  `year_course_fee` varchar(100) DEFAULT NULL,
  `refine_amount` varchar(100) DEFAULT NULL,
  `refun_status` varchar(100) DEFAULT NULL,
  `Payment_id` varchar(100) DEFAULT NULL,
  `refundTrxID` varchar(100) DEFAULT NULL,
  `marchent_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `blank_pay_dates` varchar(100) DEFAULT NULL,
  `custom_reciept` varchar(250) DEFAULT NULL,
  `delete_by_id` longtext DEFAULT NULL,
  `delete_time` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=302 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `trash_zi_payment`
INSERT INTO `trash_zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`, `delete_by_id`, `delete_time`) VALUES("301","1728015904_1624930711","1",NULL,"9","2024-01-01",NULL,NULL,"student","1",NULL,"22","BJ416HZL4X","bKash-bKash","2024-10-04 10:25:00","0","",NULL,NULL,"0",NULL,NULL,"WEB1728015846103871",NULL,"Amarpay-marchent(bKash-bKash)",NULL,NULL,"{\"lamguage\":\"en\",\"username\":\"admin\",\"uid\":\"1\",\"name\":\"admin\",\"admins\":1}","2024-10-06 18:42:45");


-- Table structure for table `update_info_institute`
DROP TABLE IF EXISTS `update_info_institute`;
CREATE TABLE `update_info_institute` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(300) NOT NULL,
  `institute_address` varchar(500) NOT NULL,
  `header_name` varchar(255) NOT NULL,
  `login_title_text` varchar(255) NOT NULL,
  `institute_name_en` varchar(255) NOT NULL,
  `institute_address_en` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `update_info_institute`
INSERT INTO `update_info_institute` (`id`, `institute_name`, `institute_address`, `header_name`, `login_title_text`, `institute_name_en`, `institute_address_en`) VALUES("1","ওয়েব বাজার বিডি স্মার্ট স্কুল","কালীগঞ্জ, লালমনিরহাট","ওয়েব বাজার বিডি স্মার্ট স্কুল","ওয়েব বাজার বিডি স্মার্ট স্কুল","ওয়েব বাজার বিডি স্মার্ট স্কুল","কালীগঞ্জ, লালমনিরহাট");


-- Table structure for table `user`
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `password` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `emailid` varchar(255) NOT NULL,
  `lastlogin` datetime NOT NULL,
  `mobile` varchar(50) NOT NULL,
  `ur_birthday` varchar(50) NOT NULL,
  `solid_pass` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `user`
INSERT INTO `user` (`id`, `username`, `password`, `name`, `emailid`, `lastlogin`, `mobile`, `ur_birthday`, `solid_pass`) VALUES("1","admin","123456","admin","webbazarbd24@gmail.com","2021-10-31 02:14:44","01713728112","2021-08-2","123456");


-- Table structure for table `user_log`
DROP TABLE IF EXISTS `user_log`;
CREATE TABLE `user_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `log_type` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `title` varchar(255) NOT NULL,
  `creator_by` int(30) NOT NULL,
  `creator_by_sub_user` int(11) NOT NULL,
  `is_read` text NOT NULL,
  `is_red_sub_user` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `user_log`


-- Table structure for table `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(50) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `two_factor_secret` text DEFAULT NULL,
  `two_factor_recovery_codes` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `users`


-- Table structure for table `vigitor_entry`
DROP TABLE IF EXISTS `vigitor_entry`;
CREATE TABLE `vigitor_entry` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `student_id` varchar(300) NOT NULL,
  `course_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `payment_date` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `total_payment` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `due` int(11) NOT NULL,
  `accept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `accept_id` int(11) DEFAULT NULL,
  `status` int(2) NOT NULL COMMENT '1 = complite_payment\r\n2 = incomplite_payment',
  `description_name` varchar(255) NOT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `survey_comment` varchar(255) NOT NULL,
  `monthly_pay_name` varchar(255) NOT NULL,
  `course_add` varchar(255) NOT NULL,
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table `vigitor_entry`
INSERT INTO `vigitor_entry` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `survey_comment`, `monthly_pay_name`, `course_add`) VALUES("35","1677026626","Md Ashraful islam","0","0","2023-02-22","","0","ashraful","1","0","01717452764",NULL,NULL,"2023-02-22 07:41:13","জানুয়ারি মাসের চাদা","কালীগঞ্জ লালমনিরহাট রংপুর","Office Application");


-- Table structure for table `year_course_fee`
DROP TABLE IF EXISTS `year_course_fee`;
CREATE TABLE `year_course_fee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `montly_fee` float NOT NULL,
  `total_course_fee` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `course_year_payment` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `year_course_fee`


-- Table structure for table `zi_mark_sheet`
DROP TABLE IF EXISTS `zi_mark_sheet`;
CREATE TABLE `zi_mark_sheet` (
  `mark_id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(100) NOT NULL,
  `condition_id` int(11) NOT NULL,
  `subject_mark` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`mark_id`)
) ENGINE=InnoDB AUTO_INCREMENT=903 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zi_mark_sheet`


-- Table structure for table `zi_payment`
DROP TABLE IF EXISTS `zi_payment`;
CREATE TABLE `zi_payment` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(100) DEFAULT NULL,
  `student_id` varchar(100) DEFAULT NULL,
  `course_id` varchar(100) DEFAULT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `payment_date` varchar(100) DEFAULT NULL,
  `total_payment` varchar(100) DEFAULT NULL,
  `due` varchar(100) DEFAULT NULL,
  `accept_name` varchar(100) DEFAULT NULL,
  `accept_id` varchar(100) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `description_name` varchar(255) DEFAULT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `discount` varchar(100) DEFAULT NULL,
  `discount_type` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `survey_comment` varchar(100) DEFAULT NULL,
  `year_course_fee` varchar(100) DEFAULT NULL,
  `refine_amount` varchar(100) DEFAULT NULL,
  `refun_status` varchar(100) DEFAULT NULL,
  `Payment_id` varchar(100) DEFAULT NULL,
  `refundTrxID` varchar(100) DEFAULT NULL,
  `marchent_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `blank_pay_dates` varchar(100) DEFAULT NULL,
  `custom_reciept` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zi_payment`
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("399","1741058842_798324185","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"14",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("400","1741058842_1392612889","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"14",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("401","1741058842_444497908","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"15",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("402","1741058842_1477541070","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"15",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("403","1741058842_150345424","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"16",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("404","1741058842_1395741939","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"16",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("405","1741058842_1059341572","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"17",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("406","1741058842_1732888417","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"17",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("407","1741058842_1193351759","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"18",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("408","1741058842_1392589258","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"18",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("409","1741058842_553979499","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"19",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("410","1741058842_1820777392","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"19",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("411","1741058842_1662715915","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"20",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("412","1741058842_129259662","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"20",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("413","1741058842_1451207968","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"22",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("414","1741058842_608960807","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"22",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("415","1741058842_386241799","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"30",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("416","1741058842_901481627","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"30",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("417","1741058842_2045431173","2031",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"31",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("418","1741058842_750013149","2032",NULL,"0","2024-02-01",NULL,NULL,"admin","1",NULL,"31",NULL,"Admin","2025-03-04 09:27:22","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-04 09:27:22",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("419","1741515300_1901314433","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"14",NULL,"Admin","2025-03-09 16:15:00","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:00",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("420","1741515301_473687419","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"14",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("421","1741515301_1395085176","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"15",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("422","1741515301_1421888854","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"15",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("423","1741515301_1959547279","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"16",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("424","1741515301_1298948040","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"16",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("425","1741515301_545184222","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"17",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("426","1741515301_1921342042","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"17",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("427","1741515301_1441772062","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"18",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("428","1741515301_1228554896","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"18",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("429","1741515301_1069150332","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"19",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("430","1741515301_858555453","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"19",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("431","1741515301_1729135779","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"20",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("432","1741515301_793009184","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"20",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("433","1741515301_1057365063","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"22",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("434","1741515301_787667919","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"22",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("435","1741515301_554863428","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"30",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("436","1741515301_968554777","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"30",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("437","1741515301_115441086","2031",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"31",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("438","1741515301_1558599924","2032",NULL,"0","2025-03-01",NULL,NULL,"admin","1",NULL,"31",NULL,"Admin","2025-03-09 16:15:01","0","0",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2025-03-09 16:15:01",NULL);
INSERT INTO `zi_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`, `discount`, `discount_type`, `survey`, `survey_comment`, `year_course_fee`, `refine_amount`, `refun_status`, `Payment_id`, `refundTrxID`, `marchent_name`, `blank_pay_dates`, `custom_reciept`) VALUES("439","1742360537_1865419235","2032",NULL,"300","2025-03-01",NULL,NULL,"admin","1",NULL,"31",NULL,"Cash","2025-03-19 00:00:00","0","",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"");


-- Table structure for table `zk_all_sms`
DROP TABLE IF EXISTS `zk_all_sms`;
CREATE TABLE `zk_all_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `sending_type` varchar(255) DEFAULT NULL,
  `attand_sending_type` varchar(255) DEFAULT NULL,
  `left_sending_type` varchar(255) DEFAULT NULL,
  `absent_sending_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_all_sms`
INSERT INTO `zk_all_sms` (`id`, `type`, `sending_type`, `attand_sending_type`, `left_sending_type`, `absent_sending_type`) VALUES("1","student","off","bn","en","en");
INSERT INTO `zk_all_sms` (`id`, `type`, `sending_type`, `attand_sending_type`, `left_sending_type`, `absent_sending_type`) VALUES("2","staff","off","en","en","en");
INSERT INTO `zk_all_sms` (`id`, `type`, `sending_type`, `attand_sending_type`, `left_sending_type`, `absent_sending_type`) VALUES("3","teacher","on","bn","en","bn");


-- Table structure for table `zk_attandance_report`
DROP TABLE IF EXISTS `zk_attandance_report`;
CREATE TABLE `zk_attandance_report` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(255) DEFAULT NULL,
  `user_type` varchar(255) DEFAULT NULL,
  `late_type` varchar(250) NOT NULL,
  `attandance_type` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `time` time DEFAULT NULL,
  `serial` varchar(255) DEFAULT NULL,
  `sending_message` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_attandance_report`
INSERT INTO `zk_attandance_report` (`id`, `main_id`, `user_type`, `late_type`, `attandance_type`, `date`, `time`, `serial`, `sending_message`) VALUES("68","1","teacher","","present","2024-08-01","13:16:00","CQU8231660008","1");


-- Table structure for table `zk_device`
DROP TABLE IF EXISTS `zk_device`;
CREATE TABLE `zk_device` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `serial` varchar(250) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `lastTime` varchar(250) DEFAULT NULL,
  `totalUser` int(20) NOT NULL DEFAULT 0,
  `totalUserCapacity` int(20) NOT NULL DEFAULT 0,
  `totalCard` int(20) NOT NULL DEFAULT 0,
  `sound1` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_device`
INSERT INTO `zk_device` (`id`, `serial`, `name`, `lastTime`, `totalUser`, `totalUserCapacity`, `totalCard`, `sound1`) VALUES("23","CQU8231660008","K60/ID","1722497466.7337494","13","3000","1","1");


-- Table structure for table `zk_device_auth`
DROP TABLE IF EXISTS `zk_device_auth`;
CREATE TABLE `zk_device_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auth1` varchar(250) NOT NULL,
  `auth2` varchar(250) NOT NULL,
  `auth3` varchar(250) NOT NULL,
  `auth4` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_device_auth`
INSERT INTO `zk_device_auth` (`id`, `auth1`, `auth2`, `auth3`, `auth4`) VALUES("5","rszqs","1000","2024-08-04","2024-07-03");


-- Table structure for table `zk_error`
DROP TABLE IF EXISTS `zk_error`;
CREATE TABLE `zk_error` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_error` varchar(11) NOT NULL DEFAULT '0',
  `daily_auth_error` varchar(11) NOT NULL DEFAULT '0',
  `total_user_error` varchar(11) NOT NULL DEFAULT '0',
  `expire_date_error` varchar(11) NOT NULL DEFAULT '0',
  `user_max_error` varchar(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_error`
INSERT INTO `zk_error` (`id`, `permission_error`, `daily_auth_error`, `total_user_error`, `expire_date_error`, `user_max_error`) VALUES("1","1","1","1","1","0");


-- Table structure for table `zk_institute_short_name`
DROP TABLE IF EXISTS `zk_institute_short_name`;
CREATE TABLE `zk_institute_short_name` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `short_name` varchar(250) NOT NULL,
  `type` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_institute_short_name`
INSERT INTO `zk_institute_short_name` (`id`, `short_name`, `type`) VALUES("7","Visit: https://webbazarbd.com","visitlink");
INSERT INTO `zk_institute_short_name` (`id`, `short_name`, `type`) VALUES("8","কালীগঞ্জ ইকরা একডেমি, লালমনিরহাট","bangla");
INSERT INTO `zk_institute_short_name` (`id`, `short_name`, `type`) VALUES("9","Kaliganj Ikra Academy, Lalmonirhat","english");


-- Table structure for table `zk_last_id`
DROP TABLE IF EXISTS `zk_last_id`;
CREATE TABLE `zk_last_id` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `last_id` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_last_id`
INSERT INTO `zk_last_id` (`id`, `last_id`) VALUES("1","227");


-- Table structure for table `zk_notice`
DROP TABLE IF EXISTS `zk_notice`;
CREATE TABLE `zk_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_notice`
INSERT INTO `zk_notice` (`id`, `notice`) VALUES("2","hello");


-- Table structure for table `zk_staff_clock`
DROP TABLE IF EXISTS `zk_staff_clock`;
CREATE TABLE `zk_staff_clock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `main_id` int(11) DEFAULT NULL,
  `staff_id` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `start_time_start` time DEFAULT NULL,
  `start_time_end` time DEFAULT NULL,
  `late_time_start` time DEFAULT NULL,
  `late_time_end` time DEFAULT NULL,
  `end_time_start` time DEFAULT NULL,
  `end_time_end` time DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_staff_clock`
INSERT INTO `zk_staff_clock` (`id`, `serial`, `name`, `main_id`, `staff_id`, `mobile`, `position`, `start_time_start`, `start_time_end`, `late_time_start`, `late_time_end`, `end_time_start`, `end_time_end`) VALUES("6","CQU8231660008","Md Fozlul Hoque","13","2024990","01717452764","Computer Op","12:00:00","14:00:00","15:01:00","16:30:00","17:00:00","18:30:00");
INSERT INTO `zk_staff_clock` (`id`, `serial`, `name`, `main_id`, `staff_id`, `mobile`, `position`, `start_time_start`, `start_time_end`, `late_time_start`, `late_time_end`, `end_time_start`, `end_time_end`) VALUES("7","CQU8231660008","Md Fozlul Hoque","11","S_250","01717452764","Supervisor","12:00:00","14:00:00","15:01:00","16:30:00","17:00:00","18:30:00");


-- Table structure for table `zk_student_clock`
DROP TABLE IF EXISTS `zk_student_clock`;
CREATE TABLE `zk_student_clock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `class` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `section` varchar(255) DEFAULT NULL,
  `shift` varchar(255) DEFAULT NULL,
  `academic_year` varchar(255) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `start_time_start` time DEFAULT NULL,
  `start_time_end` time DEFAULT NULL,
  `late_time_start` time DEFAULT NULL,
  `late_time_end` time DEFAULT NULL,
  `end_time_start` time DEFAULT NULL,
  `end_time_end` time DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_student_clock`
INSERT INTO `zk_student_clock` (`id`, `serial`, `class`, `department`, `section`, `shift`, `academic_year`, `year`, `start_time_start`, `start_time_end`, `late_time_start`, `late_time_end`, `end_time_start`, `end_time_end`) VALUES("5","CQU8231660008","3","1","6","1","4","2024","00:05:00","13:05:00","14:05:00","15:30:00","16:00:00","17:30:00");


-- Table structure for table `zk_teacher_clock`
DROP TABLE IF EXISTS `zk_teacher_clock`;
CREATE TABLE `zk_teacher_clock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `main_id` int(11) DEFAULT NULL,
  `staff_id` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `start_time_start` time DEFAULT NULL,
  `start_time_end` time DEFAULT NULL,
  `late_time_start` time DEFAULT NULL,
  `late_time_end` time DEFAULT NULL,
  `end_time_start` time DEFAULT NULL,
  `end_time_end` time DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_teacher_clock`
INSERT INTO `zk_teacher_clock` (`id`, `serial`, `name`, `main_id`, `staff_id`, `mobile`, `position`, `start_time_start`, `start_time_end`, `late_time_start`, `late_time_end`, `end_time_start`, `end_time_end`) VALUES("5","CQU8231660008","Md Ashraful Islam","1","48","01717452764","Shofiqur","09:30:00","10:00:00","10:01:00","10:30:00","16:00:00","16:30:00");


-- Table structure for table `zk_userlog`
DROP TABLE IF EXISTS `zk_userlog`;
CREATE TABLE `zk_userlog` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `authId` varchar(100) NOT NULL,
  `userId` varchar(100) NOT NULL,
  `time` varchar(250) NOT NULL,
  `status` varchar(250) NOT NULL,
  `serial` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zk_userlog`
INSERT INTO `zk_userlog` (`id`, `authId`, `userId`, `time`, `status`, `serial`) VALUES("227","13","245","2024-08-01 13:16:26","4","CQU8231660008");


-- Table structure for table `zktecho_user`
DROP TABLE IF EXISTS `zktecho_user`;
CREATE TABLE `zktecho_user` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `userId` int(20) NOT NULL,
  `authId` varchar(100) NOT NULL,
  `userName` varchar(250) NOT NULL,
  `card` varchar(250) DEFAULT '0',
  `updateStatus` int(10) NOT NULL DEFAULT 0,
  `finger_1` int(5) NOT NULL DEFAULT 0,
  `finger_2` int(5) NOT NULL DEFAULT 0,
  `finger_delete` int(5) NOT NULL DEFAULT 0,
  `deleteStatus` int(10) NOT NULL DEFAULT 1,
  `type` varchar(100) DEFAULT NULL,
  `device_serial` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=246 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zktecho_user`
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("234","165","1","Mst: Moriom","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("235","169","2","Md Ashraful Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("236","170","3","Md Aminur Rahman","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("237","171","4","Mst Janatul Mina","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("238","172","5","Mst Amina Begum","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("239","173","6","Md Rofiqul Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("240","174","7","Md Shagor Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("241","175","8","Md Ashraful Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("242","176","9","Md Ashraful Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("243","178","10","Md Ashraful Islam","0","1","0","0","0","1","student","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("244","11","S_250","Md Fozlul Hoque","0","1","0","0","0","1","staff","CQU8231660008");
INSERT INTO `zktecho_user` (`id`, `userId`, `authId`, `userName`, `card`, `updateStatus`, `finger_1`, `finger_2`, `finger_delete`, `deleteStatus`, `type`, `device_serial`) VALUES("245","1","1","Md Ashraful Islam","2536491","1","0","0","0","1","teacher","CQU8231660008");


-- Table structure for table `zktest`
DROP TABLE IF EXISTS `zktest`;
CREATE TABLE `zktest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_all` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `zktest`


